/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.chameleon.integration.IntegrationModule;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.registry.IWailaTooltipHandler;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import java.lang.reflect.Method;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class Waila
extends IntegrationModule {
    private static Class classConfigHandler;
    private static Method methInstance;
    private static Method methAddConfig;

    public String getModID() {
        return "Waila";
    }

    public void init() throws Throwable {
        classConfigHandler = Class.forName("mcp.mobius.waila.api.impl.ConfigHandler");
        methInstance = classConfigHandler.getMethod("instance", new Class[0]);
        methAddConfig = classConfigHandler.getMethod("addConfig", String.class, String.class, String.class);
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"com.jaquadro.minecraft.storagedrawers.integration.Waila.registerProvider");
    }

    public void postInit() {
    }

    public static void registerProvider(IWailaRegistrar registrar) {
        WailaDrawer provider = new WailaDrawer();
        registrar.registerBodyProvider((IWailaDataProvider)provider, BlockDrawers.class);
        registrar.registerStackProvider((IWailaDataProvider)provider, BlockDrawers.class);
        try {
            Object configHandler = methInstance.invoke(null, new Object[0]);
            methAddConfig.invoke(configHandler, "Storage Drawers", "display.content", I18n.func_135052_a((String)"storageDrawers.waila.config.displayContents", (Object[])new Object[0]), true);
            methAddConfig.invoke(configHandler, "Storage Drawers", "display.stacklimit", I18n.func_135052_a((String)"storageDrawers.waila.config.displayStackLimit", (Object[])new Object[0]), true);
            methAddConfig.invoke(configHandler, "Storage Drawers", "display.status", I18n.func_135052_a((String)"storageDrawers.waila.config.displayStatus", (Object[])new Object[0]), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class WailaDrawer
    implements IWailaDataProvider {
        public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
            List drops = accessor.getBlock().getDrops((IBlockAccess)accessor.getWorld(), accessor.getPosition(), accessor.getBlockState(), 0);
            if (drops.size() == 0) {
                return null;
            }
            return (ItemStack)drops.get(0);
        }

        public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return currenttip;
        }

        public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            TileEntityDrawers tile = (TileEntityDrawers)accessor.getTileEntity();
            if (SecurityManager.hasAccess(Minecraft.func_71410_x().field_71439_g.func_146103_bH(), tile)) {
                if (config.getConfig("display.content")) {
                    for (int i = 0; i < tile.getDrawerCount(); ++i) {
                        IDrawer drawer = tile.getDrawerIfEnabled(i);
                        if (drawer == null) continue;
                        String name = I18n.func_135052_a((String)"storageDrawers.waila.empty", (Object[])new Object[0]);
                        ItemStack stack = drawer.getStoredItemPrototype();
                        if (stack != null && stack.func_77973_b() != null) {
                            String stackName = stack.func_82833_r();
                            List<IWailaTooltipHandler> handlers = StorageDrawers.wailaRegistry.getTooltipHandlers();
                            int n = handlers.size();
                            for (int j = 0; j < n; ++j) {
                                stackName = handlers.get(j).transformItemName(drawer, stackName);
                            }
                            if (drawer.getStoredItemCount() == Integer.MAX_VALUE) {
                                name = stackName + " [\u221e]";
                            } else if (drawer instanceof IFractionalDrawer && ((IFractionalDrawer)drawer).getConversionRate() > 1) {
                                name = stackName + (i == 0 ? " [" : " [+") + ((IFractionalDrawer)drawer).getStoredItemRemainder() + "]";
                            } else if (StorageDrawers.config.cache.stackRemainderWaila) {
                                int stacks = drawer.getStoredItemCount() / drawer.getStoredItemStackSize();
                                int remainder = drawer.getStoredItemCount() - stacks * drawer.getStoredItemStackSize();
                                name = stacks > 0 && remainder > 0 ? stackName + " [" + stacks + "x" + drawer.getStoredItemStackSize() + " + " + remainder + "]" : (stacks > 0 ? stackName + " [" + stacks + "x" + drawer.getStoredItemStackSize() + "]" : stackName + " [" + remainder + "]");
                            } else {
                                name = stackName + " [" + drawer.getStoredItemCount() + "]";
                            }
                        }
                        currenttip.add(I18n.func_135052_a((String)"storageDrawers.waila.drawer", (Object[])new Object[]{i + 1, name}));
                    }
                }
                if (config.getConfig("display.stacklimit")) {
                    if (tile.isUnlimited() || tile.isVending()) {
                        currenttip.add(I18n.func_135052_a((String)"storageDrawers.waila.nolimit", (Object[])new Object[0]));
                    } else {
                        int limit = tile.getEffectiveDrawerCapacity() * tile.getEffectiveStorageMultiplier();
                        currenttip.add(I18n.func_135052_a((String)"storageDrawers.waila.limit", (Object[])new Object[]{limit, tile.getEffectiveStorageMultiplier()}));
                    }
                }
            }
            if (config.getConfig("display.status")) {
                String attrib = "";
                if (tile.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                    attrib = attrib + (attrib.isEmpty() ? "" : ", ") + I18n.func_135052_a((String)"storageDrawers.waila.locked", (Object[])new Object[0]);
                }
                if (tile.isVoid()) {
                    attrib = attrib + (attrib.isEmpty() ? "" : ", ") + I18n.func_135052_a((String)"storageDrawers.waila.void", (Object[])new Object[0]);
                }
                if (tile.isSorting()) {
                    attrib = attrib + (attrib.isEmpty() ? "" : ", ") + I18n.func_135052_a((String)"storageDrawers.waila.sorting", (Object[])new Object[0]);
                }
                if (tile.getOwner() != null) {
                    attrib = attrib + (attrib.isEmpty() ? "" : ", ") + I18n.func_135052_a((String)"storageDrawers.waila.protected", (Object[])new Object[0]);
                }
                if (!attrib.isEmpty()) {
                    currenttip.add(attrib);
                }
            }
            return currenttip;
        }

        public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return currenttip;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
            return null;
        }
    }
}

