/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.AdvMachines;

import com.chocohead.AdvMachines.AdvancedMachines;
import com.chocohead.AdvMachines.api.IRecipeLoadingTeBlock;
import com.chocohead.AdvMachines.api.Recipes;
import com.chocohead.AdvMachines.te.AdvMachineTEs;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.core.init.Rezepte;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import ic2.core.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class RecipeLoader {
    private static final Queue<PendingRecipe> PENDING_RECIPES = new ArrayDeque<PendingRecipe>();
    private static final Method WHITESPACE = ReflectionUtil.getMethod(Rezepte.class, (String[])new String[]{"splitWhitespace"}, (Class[])new Class[]{String.class});
    private static final Marker RECIPE = MarkerManager.getMarker((String)"recipe");

    public static void loadRecipes() {
        for (AdvMachineTEs machine : AdvMachineTEs.values()) {
            for (String category : machine.getRecipeCategories()) {
                Config config = new Config(category.replace('_', ' ') + " recipes");
                try {
                    config.load(Rezepte.getConfigFile((String)category));
                }
                catch (Exception e) {
                    AdvancedMachines.logger.warn(RECIPE, "Recipe loading for " + category + " failed.", (Throwable)e);
                    continue;
                }
                RecipeLoader.loadRecipes(config, machine.getManager(category), machine.getType(category));
            }
        }
        AdvancedMachines.logger.debug(RECIPE, PENDING_RECIPES.size() + " recipes failed to load in the first pass.");
    }

    public static void loadFailedRecipes() {
        PendingRecipe recipe;
        while ((recipe = PENDING_RECIPES.poll()) != null) {
            RecipeLoader.loadMachineRecipe(recipe.value, recipe.manager, recipe.machineType, true);
        }
    }

    private static void loadRecipes(Config config, IMachineRecipeManager machine, IRecipeLoadingTeBlock.MachineType type) {
        int amount = 0;
        int successful = 0;
        Iterator it = config.valueIterator();
        while (it.hasNext()) {
            if (RecipeLoader.loadMachineRecipe((Config.Value)it.next(), machine, type, false)) {
                ++successful;
            }
            ++amount;
        }
        AdvancedMachines.logger.info(RECIPE, "Successfully loaded " + successful + " out of " + amount + " recipes for " + config.name);
    }

    private static boolean loadMachineRecipe(Config.Value value, IMachineRecipeManager machine, IRecipeLoadingTeBlock.MachineType type, boolean lastAttempt) {
        IRecipeInput input;
        try {
            input = ConfigUtil.asRecipeInputWithAmount((String)value.name);
        }
        catch (ParseException e) {
            throw new Config.ParseException("invalid key", value, (Exception)e);
        }
        if (input == null) {
            if (lastAttempt) {
                AdvancedMachines.logger.warn(RECIPE, "Skipping recipe due to unresolvable input " + value.name + '.', (Throwable)new Config.ParseException("invalid input specified: " + value.name, value));
            } else {
                PENDING_RECIPES.add(new PendingRecipe(value, machine, type));
            }
            return false;
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        NBTTagCompound metadata = new NBTTagCompound();
        boolean squishOutputs = false;
        try {
            for (String part : RecipeLoader.splitWhitespace(value.getString())) {
                if (part.startsWith("@")) {
                    if (part.startsWith("@ignoreSameInputOutput")) {
                        metadata.func_74757_a("ignoreSameInputOutput", true);
                        continue;
                    }
                    if (part.startsWith("@chance:") && type == IRecipeLoadingTeBlock.MachineType.RECYCLER) {
                        int chance = Integer.parseInt(part.substring(8));
                        if (chance < 1) {
                            throw new Config.ParseException("Invalid chance: " + chance, value);
                        }
                        metadata.func_74768_a("chance", chance);
                        continue;
                    }
                    if (part.startsWith("@heat:") && type == IRecipeLoadingTeBlock.MachineType.THERMAL_CENTRIFUGE) {
                        metadata.func_74768_a("minHeat", Integer.parseInt(part.substring(6)));
                        continue;
                    }
                    throw new Config.ParseException("Invalid attribute: " + part, value);
                }
                if ("<NULL>".equals(part)) {
                    squishOutputs = true;
                    continue;
                }
                ItemStack cOutput = ConfigUtil.asStackWithAmount((String)part);
                if (cOutput == null) {
                    if (lastAttempt) {
                        AdvancedMachines.logger.warn(RECIPE, String.format("Skipping recipe using %s due to unresolvable output %s.", value.name, part), (Throwable)new Config.ParseException("invalid output specified: " + value.name, value));
                    } else {
                        PENDING_RECIPES.add(new PendingRecipe(value, machine, type));
                    }
                    return false;
                }
                outputs.add(cOutput);
            }
            if (squishOutputs) {
                if (machine.addRecipe(input, metadata.func_82582_d() ? null : metadata, true, Recipes.SKIP)) {
                    return true;
                }
                AdvancedMachines.logger.warn(RECIPE, "Couldn't remove " + input + " recipe.");
                return false;
            }
            if (type.needsTags() && (metadata.func_82582_d() || !type.hasRequiredTags(metadata))) {
                AdvancedMachines.logger.warn(RECIPE, "Could not add machine recipe: " + value.name + " missing tag.");
                return false;
            }
            if (machine.addRecipe(input, metadata.func_82582_d() ? null : metadata, false, outputs.toArray(new ItemStack[outputs.size()]))) {
                return true;
            }
            throw new Exception("Conflicting recipe");
        }
        catch (Config.ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Config.ParseException("generic parse error", value, e);
        }
    }

    private static List<String> splitWhitespace(String text) {
        if (WHITESPACE == null) {
            throw new IllegalStateException("Could not reflect whitespace method!");
        }
        try {
            return (List)WHITESPACE.invoke(null, text);
        }
        catch (Exception e) {
            throw new RuntimeException("Error reflecting whitespace", e);
        }
    }

    private static class PendingRecipe {
        final Config.Value value;
        final IMachineRecipeManager manager;
        final IRecipeLoadingTeBlock.MachineType machineType;

        PendingRecipe(Config.Value value, IMachineRecipeManager manager, IRecipeLoadingTeBlock.MachineType machineType) {
            this.value = value;
            this.manager = manager;
            this.machineType = machineType;
        }
    }
}

