/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.AdvMachines;

import com.chocohead.AdvMachines.RecipeLoader;
import com.chocohead.AdvMachines.gui.ProgressBars;
import com.chocohead.AdvMachines.item.ItemSharpPlate;
import com.chocohead.AdvMachines.te.AdvMachineTEs;
import ic2.api.event.TeBlockFinalCallEvent;
import ic2.api.info.Info;
import ic2.api.item.IC2Items;
import ic2.api.recipe.ICraftingRecipeManager;
import ic2.api.recipe.Recipes;
import ic2.core.IC2;
import ic2.core.block.BlockTileEntity;
import ic2.core.block.ITeBlock;
import ic2.core.block.TeBlockRegistry;
import ic2.core.ref.IItemModelProvider;
import ic2.core.util.ReflectionUtil;
import ic2.core.util.Util;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="advanced_machines", name="Advanced Machines", version="60.0.4", dependencies="required-after:IC2@[2.6.194-ex10,)", acceptedMinecraftVersions="[1.10]")
public final class AdvancedMachines {
    public static final String MODID = "advanced_machines";
    public static final int MINIMUM_IC2 = 194;
    public static Logger logger;
    public static BlockTileEntity machines;
    public static Item sharpPlate;

    @Mod.EventHandler
    public void start(FMLConstructionEvent event) {
        int version;
        String ic2 = (String)ReflectionUtil.getFieldValue((Field)ReflectionUtil.getField(IC2.class, (String[])new String[]{"VERSION"}), (Object)Info.ic2ModInstance);
        if (ic2 != null && !Util.inDev() && (version = Integer.parseInt(ic2.substring(ic2.lastIndexOf(46) + 1, ic2.lastIndexOf(45)))) < 194) {
            throw new LoaderException(version + " is too old an IC2 version. Advanced Machines needs a minimum of " + 194 + '.');
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void register(TeBlockFinalCallEvent event) {
        TeBlockRegistry.addAll(AdvMachineTEs.class, (ResourceLocation)AdvMachineTEs.IDENTITY);
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        machines = TeBlockRegistry.get((ResourceLocation)AdvMachineTEs.IDENTITY);
        sharpPlate = new ItemSharpPlate();
        ProgressBars.addStyles();
        if (event.getSide().isClient()) {
            ((IItemModelProvider)sharpPlate).registerModels(null);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        AdvMachineTEs.buildDummies();
        Recipes.advRecipes.addRecipe(new ItemStack(sharpPlate), new Object[]{"^^^", "^#^", "^^^", Character.valueOf('^'), Items.field_151145_ak, Character.valueOf('#'), "plateIron"});
        AdvancedMachines.addRecipe("macerator", new ItemStack(sharpPlate), AdvMachineTEs.rotary_macerator);
        AdvancedMachines.addRecipe("compressor", new ItemStack(Blocks.field_150343_Z), AdvMachineTEs.singularity_compressor);
        AdvancedMachines.addRecipe("extractor", IC2Items.getItem((String)"treetap"), AdvMachineTEs.centrifuge_extractor);
        AdvancedMachines.addRecipe("recycler", new ItemStack((Block)Blocks.field_150331_J), AdvMachineTEs.compacting_recycler);
        AdvancedMachines.addRecipe("metal_former", IC2Items.getItem((String)"fence", (String)"iron"), AdvMachineTEs.liquescent_extruder);
        AdvancedMachines.addRecipe("metal_former", IC2Items.getItem((String)"forge_hammer"), AdvMachineTEs.impellerized_roller, true);
        AdvancedMachines.addRecipe("metal_former", IC2Items.getItem((String)"cutter"), AdvMachineTEs.water_jet_cutter, true);
        AdvancedMachines.addRecipe("ore_washing_plant", IC2Items.getItem((String)"dust", (String)"sulfur"), AdvMachineTEs.thermal_washer);
        RecipeLoader.loadRecipes();
    }

    private static void addRecipe(String baseMachine, ItemStack surroundItem, AdvMachineTEs output) {
        AdvancedMachines.addRecipe(baseMachine, surroundItem, output, false);
    }

    private static void addRecipe(String baseMachine, ItemStack surroundItem, AdvMachineTEs output, boolean consuming) {
        Recipes.advRecipes.addRecipe(machines.getItemStack((ITeBlock)output), new Object[]{"###", "#M#", "#X#", Character.valueOf('#'), surroundItem, Character.valueOf('M'), IC2Items.getItem((String)"te", (String)baseMachine), Character.valueOf('X'), IC2Items.getItem((String)"resource", (String)"advanced_machine"), new ICraftingRecipeManager.AttributeContainer(false, consuming)});
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        RecipeLoader.loadFailedRecipes();
        logger.info("Advanced Machines 60.0.4 loaded.");
    }
}

