/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail;

import com.minemaarten.signals.capabilities.CapabilityMinecartDestination;
import com.minemaarten.signals.inventory.ContainerNetworkController;
import com.minemaarten.signals.network.NetworkHandler;
import com.minemaarten.signals.network.PacketUpdateNetworkController;
import com.minemaarten.signals.rail.RailCacheManager;
import com.minemaarten.signals.rail.RailWrapper;
import com.minemaarten.signals.tileentity.TileEntitySignalBase;
import com.minemaarten.signals.tileentity.TileEntityStationMarker;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class NetworkController {
    private static final Map<Integer, NetworkController> SERVER_INSTANCES = new HashMap<Integer, NetworkController>();
    private static final Map<Integer, NetworkController> CLIENT_INSTANCES = new HashMap<Integer, NetworkController>();
    private static final int RAIL_COLOR = -10066330;
    private static final int PATH_COLOR = -5592406;
    private static final int TEXT_COLOR = 0xFFFFFF;
    private static final int STATION_COLOR = -2237184;
    private static final int NOTHING_COLOR = -14540254;
    @SideOnly(value=Side.CLIENT)
    private DynamicTexture dynamicTexture;
    private int width;
    private int height;
    private int[] colors;
    private int startX;
    private int startZ;
    private final int dimensionId;
    private ResourceLocation textureLoc;

    public static NetworkController getInstance(World world) {
        return NetworkController.getInstance(world.field_73011_w.getDimension(), world.field_72995_K);
    }

    public static NetworkController getInstance(int dimension, boolean client) {
        Map<Integer, NetworkController> cache = client ? CLIENT_INSTANCES : SERVER_INSTANCES;
        NetworkController controller = cache.get(dimension);
        if (controller == null) {
            controller = new NetworkController(dimension);
            if (client) {
                controller.setColors(new int[]{0}, 1, 1, 0, 0);
            }
            cache.put(dimension, controller);
            if (!client) {
                controller.rebuildAll();
            }
        }
        return controller;
    }

    public NetworkController(int dimensionId) {
        this.dimensionId = dimensionId;
    }

    @SideOnly(value=Side.CLIENT)
    public void setColors(int[] colors, int width, int height, int startX, int startZ) {
        this.startX = startX;
        this.startZ = startZ;
        if (this.dynamicTexture == null || this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            if (this.dynamicTexture != null) {
                this.dynamicTexture.func_147631_c();
            }
            this.dynamicTexture = new DynamicTexture(width, height);
            this.textureLoc = Minecraft.func_71410_x().func_110434_K().func_110578_a("networkController/" + this.dimensionId, this.dynamicTexture);
        }
        System.arraycopy(colors, 0, this.dynamicTexture.func_110565_c(), 0, colors.length);
        this.dynamicTexture.func_110564_a();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartZ() {
        return this.startZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(World world) {
        if (this.textureLoc == null) {
            this.setColors(new int[1], 1, 1, 0, 0);
        }
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(this.textureLoc);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (float)this.width, (float)this.height);
        Tessellator t = Tessellator.func_178181_a();
        VertexBuffer buffer = t.func_178180_c();
        for (EntityMinecart cart : world.func_72872_a(EntityMinecart.class, new AxisAlignedBB((double)this.startX, 0.0, (double)this.startZ, (double)(this.startX + this.width), 255.0, (double)(this.startZ + this.height)))) {
            List<BlockPos> path = ((CapabilityMinecartDestination)cart.getCapability(CapabilityMinecartDestination.INSTANCE, null)).getNBTPath();
            if (path == null) continue;
            for (BlockPos pathPos : path) {
                int pathX = pathPos.func_177958_n() - this.startX;
                int pathZ = pathPos.func_177952_p() - this.startZ;
                Gui.func_73734_a((int)pathX, (int)pathZ, (int)(pathX + 1), (int)(pathZ + 1), (int)-5592406);
            }
        }
        for (EntityMinecart cart : world.func_72872_a(EntityMinecart.class, new AxisAlignedBB((double)this.startX, 0.0, (double)this.startZ, (double)(this.startX + this.width), 255.0, (double)(this.startZ + this.height)))) {
            double x = cart.field_70165_t - (double)this.startX - 0.5;
            double y = cart.field_70161_v - (double)this.startZ - 0.5;
            GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179090_x();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            buffer.func_181662_b(x, y, 0.0).func_181675_d();
            buffer.func_181662_b(x, y + 1.0, 0.0).func_181675_d();
            buffer.func_181662_b(x + 1.0, y + 1.0, 0.0).func_181675_d();
            buffer.func_181662_b(x + 1.0, y, 0.0).func_181675_d();
            t.func_78381_a();
            GlStateManager.func_179098_w();
            String dest = ((CapabilityMinecartDestination)cart.getCapability(CapabilityMinecartDestination.INSTANCE, null)).getCurrentDestination();
            if (dest == null) continue;
            GlStateManager.func_179094_E();
            double scale = 0.25;
            GlStateManager.func_179137_b((double)(x + 1.5), (double)y, (double)0.0);
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            mc.field_71466_p.func_78276_b(dest, 0, 0, 0xFFFFFF);
            GlStateManager.func_179121_F();
        }
        for (TileEntity te : world.field_147482_g) {
            if (!(te instanceof TileEntityStationMarker)) continue;
            double x = (double)(te.func_174877_v().func_177958_n() - this.startX) - 0.5;
            double y = (double)(te.func_174877_v().func_177952_p() - this.startZ) - 0.5;
            GlStateManager.func_179094_E();
            double scale = 0.25;
            GlStateManager.func_179137_b((double)(x + 2.0), (double)y, (double)0.0);
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            mc.field_71466_p.func_78276_b(((TileEntityStationMarker)te).getStationName(), 0, 0, -256);
            GlStateManager.func_179121_F();
        }
    }

    private void setColor(int x, int z, int color) {
        this.setColor(x, z, color, true);
    }

    private void setColor(int x, int z, int color, boolean sendPacket) {
        int index = x - this.startX + (z - this.startZ) * this.width;
        if (index < 0 || index >= this.colors.length) {
            this.rebuildAll();
        } else if (this.colors[index] != color) {
            this.colors[index] = color;
            if (sendPacket) {
                this.sendUpdatePacket();
            }
        }
    }

    private void sendUpdatePacket() {
        PacketUpdateNetworkController packet = new PacketUpdateNetworkController(this.dimensionId, this.colors, this.width, this.height, this.startX, this.startZ);
        for (EntityPlayer player : DimensionManager.getWorld((int)this.dimensionId).field_73010_i) {
            if (!this.shouldPlayerGetUpdates(player)) continue;
            NetworkHandler.sendTo(packet, (EntityPlayerMP)player);
        }
    }

    private boolean shouldPlayerGetUpdates(EntityPlayer player) {
        return player.field_71070_bA instanceof ContainerNetworkController;
    }

    public void updateColor(RailWrapper rail, BlockPos pos) {
        this.updateColor(rail != null ? -10066330 : -14540254, pos);
    }

    public void updateColor(TileEntitySignalBase signal, BlockPos pos) {
        this.updateColor(signal != null ? signal.getLampStatus().color : -14540254, pos);
    }

    public void updateColor(TileEntityStationMarker station, BlockPos pos) {
        this.updateColor(station != null ? -2237184 : -14540254, pos);
    }

    public void updateColor(int color, BlockPos ... positions) {
        boolean rebuildAll = false;
        for (BlockPos pos : positions) {
            if (color == -14540254) {
                if (pos.func_177958_n() == this.startX || pos.func_177958_n() == this.startX + this.width || pos.func_177952_p() == this.startZ || pos.func_177952_p() == this.startZ + this.height) {
                    rebuildAll = true;
                }
            } else if (pos.func_177958_n() < this.startX || pos.func_177958_n() >= this.startX + this.width || pos.func_177952_p() < this.startZ || pos.func_177952_p() >= this.startZ + this.height) {
                rebuildAll = true;
            }
            if (rebuildAll) continue;
            this.setColor(pos.func_177958_n(), pos.func_177952_p(), color);
        }
        if (rebuildAll) {
            this.rebuildAll();
        }
    }

    public void rebuildAll() {
        Iterable<RailWrapper> allRails = RailCacheManager.getInstance(this.dimensionId).getAllRails();
        HashMap<BlockPos, Integer> posToColor = new HashMap<BlockPos, Integer>();
        for (RailWrapper wrapper : allRails) {
            posToColor.put(wrapper, -10066330);
        }
        try {
            for (TileEntity te : DimensionManager.getWorld((int)this.dimensionId).field_175730_i) {
                if (te instanceof TileEntitySignalBase) {
                    posToColor.put(te.func_174877_v(), ((TileEntitySignalBase)te).getLampStatus().color);
                    continue;
                }
                if (!(te instanceof TileEntityStationMarker)) continue;
                posToColor.put(te.func_174877_v(), -2237184);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        this.startX = Integer.MAX_VALUE;
        this.startZ = Integer.MAX_VALUE;
        int endX = Integer.MIN_VALUE;
        int endZ = Integer.MIN_VALUE;
        for (BlockPos blockPos : posToColor.keySet()) {
            this.startX = Math.min(this.startX, blockPos.func_177958_n());
            this.startZ = Math.min(this.startZ, blockPos.func_177952_p());
            endX = Math.max(endX, blockPos.func_177958_n());
            endZ = Math.max(endZ, blockPos.func_177952_p());
        }
        if (posToColor.isEmpty()) {
            this.width = 1;
            this.height = 1;
            this.colors = new int[1];
            Arrays.fill(this.colors, -14540254);
        } else {
            this.width = endX - this.startX + 1;
            this.height = endZ - this.startZ + 1;
            this.colors = new int[this.width * this.height];
            Arrays.fill(this.colors, -14540254);
            for (Map.Entry entry : posToColor.entrySet()) {
                this.setColor(((BlockPos)entry.getKey()).func_177958_n(), ((BlockPos)entry.getKey()).func_177952_p(), (Integer)entry.getValue(), false);
            }
        }
        this.sendUpdatePacket();
    }
}

