/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.item;

import com.minemaarten.signals.Signals;
import com.minemaarten.signals.api.tileentity.IDestinationProvider;
import com.minemaarten.signals.capabilities.CapabilityDestinationProvider;
import com.minemaarten.signals.item.ItemSignals;
import com.minemaarten.signals.proxy.CommonProxy;
import com.minemaarten.signals.rail.RailCacheManager;
import com.minemaarten.signals.rail.RailWrapper;
import com.minemaarten.signals.tileentity.TileEntityRailLink;
import com.minemaarten.signals.tileentity.TileEntityStationMarker;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ItemRailConfigurator
extends ItemSignals {
    public ItemRailConfigurator() {
        super("rail_configurator");
        this.func_77625_d(1);
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        CapabilityDestinationProvider cap;
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) != null && (cap = (CapabilityDestinationProvider)te.getCapability(CapabilityDestinationProvider.INSTANCE, null)) != null) {
            List<IDestinationProvider> providers = cap.getApplicableDestinationProviders();
            ArrayList<IDestinationProvider> guiProviders = new ArrayList<IDestinationProvider>();
            for (IDestinationProvider provider : providers) {
                if (!provider.hasGui(te)) continue;
                guiProviders.add(provider);
            }
            if (guiProviders.size() > 1) {
                player.openGui((Object)Signals.instance, CommonProxy.EnumGuiId.SELECT_DESTINATION_PROVIDER.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                return EnumActionResult.SUCCESS;
            }
            if (!guiProviders.isEmpty()) {
                ((IDestinationProvider)guiProviders.get(0)).openGui(te, player);
                return EnumActionResult.SUCCESS;
            }
        }
        return super.onItemUseFirst(stack, player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!worldIn.field_72995_K && playerIn.func_70093_af()) {
            RailCacheManager.getInstance(worldIn).onWorldUnload(worldIn);
            RailCacheManager cacheManager = RailCacheManager.getInstance(worldIn);
            for (TileEntity te : worldIn.field_147482_g) {
                if (!(te instanceof TileEntityStationMarker)) continue;
                cacheManager.addStationMarker((TileEntityStationMarker)te);
            }
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("signals.message.clearedCache", new Object[0]));
        }
        return super.func_77659_a(itemStackIn, worldIn, playerIn, hand);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            RailWrapper rail = RailCacheManager.getInstance(worldIn).getRail(worldIn, pos);
            if (rail != null) {
                this.setLinkedRail(stack, rail);
                playerIn.func_145747_a((ITextComponent)new TextComponentString("Pos: " + pos));
            } else {
                TileEntity te = worldIn.func_175625_s(pos);
                if (te instanceof TileEntityRailLink && (rail = this.getLinkedRail(stack)) != null) {
                    ((TileEntityRailLink)te).setLinkedRail(rail);
                    playerIn.func_145747_a((ITextComponent)new TextComponentString("Linked to " + (Object)((Object)rail)));
                }
            }
        }
        return super.func_180614_a(stack, playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public void setLinkedRail(ItemStack stack, RailWrapper rail) {
        if (rail != null) {
            NBTTagCompound tag = stack.func_179543_a("linkingRail", true);
            tag.func_74768_a("x", rail.func_177958_n());
            tag.func_74768_a("y", rail.func_177956_o());
            tag.func_74768_a("z", rail.func_177952_p());
            tag.func_74768_a("dim", rail.world.field_73011_w.getDimension());
        } else if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o("linkingRail");
        }
    }

    public RailWrapper getLinkedRail(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("linkingRail", false);
        if (tag != null) {
            BlockPos pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
            WorldServer world = DimensionManager.getWorld((int)tag.func_74762_e("dim"));
            if (world != null) {
                RailWrapper rail = RailCacheManager.getInstance((World)world).getRail((World)world, pos);
                return rail;
            }
        }
        return null;
    }
}

