/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.loot;

import com.teammetallurgy.aquaculture.items.AquacultureItems;
import com.teammetallurgy.aquaculture.loot.BiomeType;
import com.teammetallurgy.aquaculture.loot.WeightedLootSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class FishLoot {
    public static FishLoot instance;
    Map<BiomeType, WeightedLootSet> fishBiomeMap;
    Map<BiomeType, WeightedLootSet> junkBiomeMap = new HashMap<BiomeType, WeightedLootSet>();

    private FishLoot() {
        this.fishBiomeMap = new HashMap<BiomeType, WeightedLootSet>();
    }

    public static FishLoot instance() {
        if (instance == null) {
            instance = new FishLoot();
        }
        return instance;
    }

    public void addBiome(BiomeType biome) {
        this.junkBiomeMap.put(biome, new WeightedLootSet());
        this.fishBiomeMap.put(biome, new WeightedLootSet());
    }

    public void addFish(ItemStack fish, BiomeType biome, int rarity) {
        if (!this.fishBiomeMap.containsKey(biome)) {
            this.fishBiomeMap.put(biome, new WeightedLootSet());
        }
        this.fishBiomeMap.get(biome).addLoot(fish, rarity, 1, 1);
    }

    public void addJunkLoot(ItemStack junk, int rarity) {
        for (WeightedLootSet lootSet : this.junkBiomeMap.values()) {
            lootSet.addLoot(junk, rarity, 1, 1);
        }
    }

    public void addJunkLoot(ItemStack junk, BiomeType[] biomes, int rarity) {
        for (BiomeType biome : biomes) {
            this.addJunkLoot(junk, biome, rarity);
        }
    }

    public void addJunkLoot(ItemStack fish, BiomeType biome, int rarity) {
        if (!this.junkBiomeMap.containsKey(biome)) {
            this.junkBiomeMap.put(biome, new WeightedLootSet());
        }
        this.junkBiomeMap.get(biome).addLoot(fish, rarity, 1, 1);
    }

    public ItemStack getRandomFish(int biomeID) {
        BiomeType biome = BiomeType.getBiomeType(biomeID);
        ItemStack fishStack = null;
        fishStack = biome != null && this.fishBiomeMap.containsKey(biome) ? this.fishBiomeMap.get(biome).getRandomLoot() : this.fishBiomeMap.get(BiomeType.freshwater).getRandomLoot();
        return fishStack;
    }

    public ItemStack getRandomFish(int biomeID, int heavyLineLvl) {
        BiomeType biome = BiomeType.getBiomeType(biomeID);
        ItemStack fishStack = null;
        fishStack = biome != null && this.fishBiomeMap.containsKey(biome) ? this.fishBiomeMap.get(biome).getRandomLoot() : this.fishBiomeMap.get(BiomeType.freshwater).getRandomLoot();
        AquacultureItems.fish.assignRandomWeight(fishStack, heavyLineLvl);
        return fishStack;
    }

    public ItemStack getRandomJunk(int biomeID) {
        BiomeType biome = BiomeType.getBiomeType(biomeID);
        if (biome != null && this.junkBiomeMap.containsKey(biome)) {
            return this.junkBiomeMap.get(biome).getRandomLoot();
        }
        return this.junkBiomeMap.get(BiomeType.freshwater).getRandomLoot();
    }
}

