/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.sleepingbag;

import java.beans.ConstructorProperties;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.shadowfacts.shadowmc.network.PacketBase;
import net.shadowfacts.sleepingbag.ItemSleepingBag;

public class PacketSleep
extends PacketBase<PacketSleep, IMessage> {
    public UUID id;
    public int dimension;
    public BlockPos pos;
    public EnumHand hand;

    public IMessage onMessage(PacketSleep message, MessageContext ctx) {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.dimension);
        EntityPlayer player = world.func_152378_a(message.id);
        ItemSleepingBag.useSleepingBag(player, (World)world, message.pos, message.hand);
        return null;
    }

    public PacketSleep() {
    }

    @ConstructorProperties(value={"id", "dimension", "pos", "hand"})
    public PacketSleep(UUID id, int dimension, BlockPos pos, EnumHand hand) {
        this.id = id;
        this.dimension = dimension;
        this.pos = pos;
        this.hand = hand;
    }

    static {
        PacketSleep.addHandlers(UUID.class, buf -> new UUID(buf.readLong(), buf.readLong()), (val, buf) -> {
            buf.writeLong(val.getMostSignificantBits());
            buf.writeLong(val.getLeastSignificantBits());
        });
        PacketSleep.addHandlers(EnumHand.class, buf -> buf.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND, (val, buf) -> buf.writeBoolean(val == EnumHand.MAIN_HAND));
    }
}

