/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import baubles.api.BaubleType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import vazkii.botania.api.item.ISortableTool;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemSwapRing
extends ItemBauble {
    public ItemSwapRing() {
        super("swapRing");
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        ItemStack currentStack = player.func_184614_ca();
        if (currentStack == null || !(currentStack.func_77973_b() instanceof ISortableTool)) {
            return;
        }
        ISortableTool tool = (ISortableTool)currentStack.func_77973_b();
        RayTraceResult pos = ToolCommons.raytraceFromEntity(entity.field_70170_p, (Entity)entity, true, 4.5);
        ISortableTool.ToolType typeToFind = null;
        if (player.field_82175_bq && pos != null && pos.func_178782_a() != null) {
            IBlockState state = entity.field_70170_p.func_180495_p(pos.func_178782_a());
            Material mat = state.func_185904_a();
            if (ToolCommons.isRightMaterial(mat, ToolCommons.materialsPick)) {
                typeToFind = ISortableTool.ToolType.PICK;
            } else if (ToolCommons.isRightMaterial(mat, ToolCommons.materialsShovel)) {
                typeToFind = ISortableTool.ToolType.SHOVEL;
            } else if (ToolCommons.isRightMaterial(mat, ToolCommons.materialsAxe)) {
                typeToFind = ISortableTool.ToolType.AXE;
            }
        }
        if (typeToFind == null) {
            return;
        }
        ItemStack bestTool = currentStack;
        int bestToolPriority = tool.getSortingType(currentStack) == typeToFind ? tool.getSortingPriority(currentStack) : -1;
        int bestSlot = -1;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            int priority;
            ISortableTool toolInSlot;
            ItemStack stackInSlot = player.field_71071_by.func_70301_a(i);
            if (stackInSlot == null || !(stackInSlot.func_77973_b() instanceof ISortableTool) || stackInSlot == currentStack || !(toolInSlot = (ISortableTool)stackInSlot.func_77973_b()).getSortingType(stackInSlot).equals((Object)typeToFind) || (priority = toolInSlot.getSortingPriority(stackInSlot)) <= bestToolPriority) continue;
            bestTool = stackInSlot;
            bestToolPriority = priority;
            bestSlot = i;
        }
        if (bestSlot != -1) {
            player.func_184611_a(EnumHand.MAIN_HAND, bestTool);
            player.field_71071_by.func_70299_a(bestSlot, currentStack);
        }
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.RING;
    }
}

