/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.loot;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.botania.common.core.loot.BindUuid;
import vazkii.botania.common.core.loot.EnableRelics;
import vazkii.botania.common.core.loot.TrueGuardianKiller;

public final class LootHandler {
    private static final List<String> TABLES = ImmutableList.of((Object)"gaia_guardian", (Object)"gaia_guardian_2", (Object)"inject/abandoned_mineshaft", (Object)"inject/desert_pyramid", (Object)"inject/jungle_temple", (Object)"inject/simple_dungeon", (Object)"inject/spawn_bonus_chest", (Object)"inject/stronghold_corridor", (Object)"inject/village_blacksmith");

    public LootHandler() {
        for (String s : TABLES) {
            LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("Botania", s));
        }
        LootConditionManager.func_186639_a((LootCondition.Serializer)new TrueGuardianKiller.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new EnableRelics.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new BindUuid.Serializer());
    }

    @SubscribeEvent
    public void lootLoad(LootTableLoadEvent evt) {
        String prefix = "minecraft:chests/";
        String name = evt.getName().toString();
        if (name.startsWith(prefix)) {
            String file;
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "abandoned_mineshaft": 
                case "desert_pyramid": 
                case "jungle_temple": 
                case "simple_dungeon": 
                case "spawn_bonus_chest": 
                case "stronghold_corridor": 
                case "village_blacksmith": {
                    evt.getTable().addPool(this.getInjectPool(file));
                    break;
                }
            }
        }
    }

    private LootPool getInjectPool(String entryName) {
        return new LootPool(new LootEntry[]{this.getInjectEntry(entryName, 1)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "botania_inject_pool");
    }

    private LootEntryTable getInjectEntry(String name, int weight) {
        return new LootEntryTable(new ResourceLocation("Botania", "inject/" + name), weight, 0, new LootCondition[0], "botania_inject_entry");
    }
}

