/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyReceiver;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Optional;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.tile.TileMod;

@Optional.Interface(iface="cofh.api.energy.IEnergyConnection", modid="CoFHAPI|energy")
public class TileRFGenerator
extends TileMod
implements IManaReceiver,
IEnergyConnection {
    private static final int CONVERSION_RATE = 10;
    private static final int MAX_MANA = 12800;
    private static final String TAG_MANA = "mana";
    int mana = 0;
    private final EnumMap<EnumFacing, IEnergyReceiver> receiverCache = new EnumMap(EnumFacing.class);
    private boolean deadCache;

    @Optional.Method(modid="CoFHAPI|energy")
    public void func_145829_t() {
        super.func_145829_t();
        this.deadCache = true;
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && Botania.rfApiLoaded) {
            if (this.deadCache) {
                this.reCache();
            }
            int transfer = Math.min(this.mana, 1600);
            this.mana -= transfer;
            this.mana += this.transmitEnergy(transfer);
        }
    }

    @Optional.Method(modid="CoFHAPI|energy")
    private final int transmitEnergy(int energy) {
        for (Map.Entry<EnumFacing, IEnergyReceiver> e : this.receiverCache.entrySet()) {
            IEnergyReceiver tile = e.getValue();
            if (tile == null || (energy -= tile.receiveEnergy(e.getKey().func_176734_d(), energy, false)) > 0) continue;
            return 0;
        }
        return energy;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    private void reCache() {
        if (this.deadCache) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                this.onNeighborTileChange(this.field_174879_c.func_177972_a(dir));
            }
            this.deadCache = false;
        }
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public void onNeighborTileChange(BlockPos pos) {
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        BlockPos q = this.func_174877_v();
        EnumFacing side = EnumFacing.func_176737_a((float)(pos.func_177958_n() - q.func_177958_n()), (float)(pos.func_177956_o() - q.func_177956_o()), (float)(pos.func_177952_p() - q.func_177952_p()));
        this.addCache(tile, side);
    }

    @Optional.Method(modid="CoFHAPI|energy")
    private void addCache(TileEntity tile, EnumFacing side) {
        this.receiverCache.remove(side);
        if (tile instanceof IEnergyReceiver) {
            this.receiverCache.put(side, (IEnergyReceiver)tile);
        }
    }

    @Override
    public int getCurrentMana() {
        return this.mana / 10;
    }

    @Override
    public boolean isFull() {
        return this.mana >= 12800;
    }

    @Override
    public void recieveMana(int mana) {
        this.mana = Math.min(12800, this.mana + mana * 10);
    }

    @Override
    public boolean canRecieveManaFromBursts() {
        return true;
    }

    @Override
    public void writePacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
    }

    @Override
    public void readPacketNBT(NBTTagCompound cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }
}

