/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.sound.BotaniaSoundEvents;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileFunctional;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.lexicon.LexiconData;

public class SubTileAgricarnation
extends SubTileFunctional {
    private static final int RANGE = 5;
    private static final int RANGE_MINI = 2;

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.supertile.func_145831_w().field_72995_K) {
            return;
        }
        if (this.ticksExisted % 200 == 0) {
            this.sync();
        }
        if (this.ticksExisted % 6 == 0 && this.redstoneSignal == 0) {
            int range = this.getRange();
            int x = this.supertile.func_174877_v().func_177958_n() + this.supertile.func_145831_w().field_73012_v.nextInt(range * 2 + 1) - range;
            int z = this.supertile.func_174877_v().func_177952_p() + this.supertile.func_145831_w().field_73012_v.nextInt(range * 2 + 1) - range;
            for (int i = 4; i > -2; --i) {
                int y = this.supertile.func_174877_v().func_177956_o() + i;
                BlockPos pos = new BlockPos(x, y, z);
                if (this.supertile.func_145831_w().func_175623_d(pos) || !this.isPlant(pos) || this.mana <= 5) continue;
                Block block = this.supertile.func_145831_w().func_180495_p(pos).func_177230_c();
                this.mana -= 5;
                this.supertile.func_145831_w().func_175684_a(pos, block, 1);
                if (ConfigHandler.blockBreakParticles) {
                    this.supertile.func_145831_w().func_175718_b(2005, pos, 6 + this.supertile.func_145831_w().field_73012_v.nextInt(4));
                }
                this.supertile.func_145831_w().func_184148_a(null, (double)x, (double)y, (double)z, BotaniaSoundEvents.agricarnation, SoundCategory.BLOCKS, 0.01f, 0.5f + (float)Math.random() * 0.5f);
                break;
            }
        }
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    private boolean isPlant(BlockPos pos) {
        IBlockState state = this.supertile.func_145831_w().func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150349_c || block == Blocks.field_150362_t || block == Blocks.field_150361_u || block instanceof BlockBush && !(block instanceof BlockCrops) && !(block instanceof BlockSapling)) {
            return false;
        }
        Material mat = state.func_185904_a();
        return mat != null && (mat == Material.field_151585_k || mat == Material.field_151570_A || mat == Material.field_151577_b || mat == Material.field_151584_j || mat == Material.field_151572_C) && block instanceof IGrowable && ((IGrowable)block).func_176473_a(this.supertile.func_145831_w(), pos, this.supertile.func_145831_w().func_180495_p(pos), this.supertile.func_145831_w().field_72995_K);
    }

    @Override
    public int getColor() {
        return 9369640;
    }

    @Override
    public int getMaxMana() {
        return 200;
    }

    public int getRange() {
        return 5;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), this.getRange());
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.agricarnation;
    }

    public static class Mini
    extends SubTileAgricarnation {
        @Override
        public int getRange() {
            return 2;
        }
    }
}

