/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.awt.Color;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.subtile.functional.SubTileBergamute;
import vazkii.botania.common.block.tile.mana.TilePool;

@SideOnly(value=Side.CLIENT)
public class BergamuteEventHandler {
    private static final Random RAND = new Random();
    private static final float MULTIPLIER = 0.15f;

    private BergamuteEventHandler() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onSoundEvent(PlaySoundEvent evt) {
        ISound sound = evt.getResultSound();
        if (sound != null && BergamuteEventHandler.shouldSilence(sound)) {
            if (sound instanceof ITickableSound) {
                evt.setResultSound((ISound)new WrappedTickableSound((ITickableSound)sound, 0.15f));
            } else {
                SubTileBergamute berg = SubTileBergamute.getBergamuteNearby(sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i());
                if (berg != null) {
                    evt.setResultSound((ISound)new WrappedSound(sound, 0.15f));
                    if (RAND.nextBoolean()) {
                        Color color = TilePool.PARTICLE_COLOR;
                        BotaniaAPI.internalHandler.sparkleFX(berg.getWorld(), (double)berg.getPos().func_177958_n() + 0.3 + Math.random() * 0.5, (double)berg.getPos().func_177956_o() + 0.5 + Math.random() * 0.5, (double)berg.getPos().func_177952_p() + 0.3 + Math.random() * 0.5, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)Math.random(), 5);
                    }
                }
            }
        }
    }

    private static boolean shouldSilence(ISound sound) {
        return sound.func_184365_d() != SoundCategory.VOICE && sound.func_184365_d() != SoundCategory.MUSIC && sound.getClass().getName().startsWith("net.minecraft.client.audio");
    }

    @SideOnly(value=Side.CLIENT)
    private static class WrappedTickableSound
    extends WrappedSound
    implements ITickableSound {
        private final ITickableSound compose;

        private WrappedTickableSound(ITickableSound toWrap, float volMult) {
            super((ISound)toWrap, volMult);
            this.compose = toWrap;
        }

        public boolean func_147667_k() {
            return this.compose.func_147667_k();
        }

        public void func_73660_a() {
            this.compose.func_73660_a();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class WrappedSound
    implements ISound {
        private final ISound compose;
        private final float volMult;
        private final boolean recheck;

        private WrappedSound(ISound toWrap, float volMult) {
            this.compose = toWrap;
            this.volMult = volMult;
            this.recheck = toWrap instanceof MovingSound;
        }

        public float func_147653_e() {
            float mult = this.recheck && SubTileBergamute.getBergamuteNearby(this.func_147649_g(), this.func_147654_h(), this.func_147651_i()) == null ? 1.0f : this.volMult;
            return this.compose.func_147653_e() * mult;
        }

        @Nonnull
        public ResourceLocation func_147650_b() {
            return this.compose.func_147650_b();
        }

        @Nullable
        public SoundEventAccessor func_184366_a(@Nonnull SoundHandler handler) {
            return this.compose.func_184366_a(handler);
        }

        @Nonnull
        public Sound func_184364_b() {
            return this.compose.func_184364_b();
        }

        @Nonnull
        public SoundCategory func_184365_d() {
            return this.compose.func_184365_d();
        }

        public boolean func_147657_c() {
            return this.compose.func_147657_c();
        }

        public int func_147652_d() {
            return this.compose.func_147652_d();
        }

        public float func_147655_f() {
            return this.compose.func_147655_f();
        }

        public float func_147649_g() {
            return this.compose.func_147649_g();
        }

        public float func_147654_h() {
            return this.compose.func_147654_h();
        }

        public float func_147651_i() {
            return this.compose.func_147651_i();
        }

        @Nonnull
        public ISound.AttenuationType func_147656_j() {
            return this.compose.func_147656_j();
        }
    }
}

