/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import vazkii.botania.client.core.handler.ClientMethodHandles;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.common.item.ItemAstrolabe;

public final class AstrolabePreviewHandler {
    @SubscribeEvent
    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        List playerEntities = world.field_73010_i;
        for (EntityPlayer player : playerEntities) {
            Block block;
            ItemStack currentStack = player.func_184614_ca();
            if (currentStack == null || !(currentStack.func_77973_b() instanceof ItemAstrolabe)) {
                currentStack = player.func_184592_cb();
            }
            if (currentStack == null || !(currentStack.func_77973_b() instanceof ItemAstrolabe) || (block = ItemAstrolabe.getBlock(currentStack)) == Blocks.field_150350_a) continue;
            AstrolabePreviewHandler.renderPlayerLook(player, currentStack);
        }
    }

    private static void renderPlayerLook(EntityPlayer player, ItemStack stack) {
        BlockPos[] coords = ItemAstrolabe.getBlocksToPlace(stack, player);
        if (ItemAstrolabe.hasBlocks(stack, player, coords)) {
            Block block = ItemAstrolabe.getBlock(stack);
            int meta = ItemAstrolabe.getBlockMeta(stack);
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            ShaderHelper.useShader(ShaderHelper.alpha, shader -> {
                int alpha = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"alpha");
                ARBShaderObjects.glUniform1fARB((int)alpha, (float)0.4f);
            });
            for (BlockPos coord : coords) {
                AstrolabePreviewHandler.renderBlockAt(block, meta, coord);
            }
            ShaderHelper.releaseShader();
            GL11.glPopMatrix();
        }
    }

    private static void renderBlockAt(Block block, int meta, BlockPos pos) {
        double renderPosZ;
        double renderPosY;
        double renderPosX;
        IBlockState state = block.func_176203_a(meta);
        if (state == null) {
            return;
        }
        try {
            renderPosX = ClientMethodHandles.renderPosX_getter.invokeExact(Minecraft.func_71410_x().func_175598_ae());
            renderPosY = ClientMethodHandles.renderPosY_getter.invokeExact(Minecraft.func_71410_x().func_175598_ae());
            renderPosZ = ClientMethodHandles.renderPosZ_getter.invokeExact(Minecraft.func_71410_x().func_175598_ae());
        }
        catch (Throwable t) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-renderPosX), (double)(-renderPosY), (double)(-renderPosZ));
        GlStateManager.func_179097_i();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)(pos.func_177952_p() + 1));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        brd.func_175016_a(state, 1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }
}

