/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.world.features;

import com.google.common.base.Predicate;
import elec332.core.world.features.FeatureWorldGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.config.Configuration;

public class FeatureWorldGenMinable
extends FeatureWorldGenerator {
    public static final Predicate<IBlockState> STONE = BlockMatcher.func_177642_a((Block)Blocks.field_150348_b);
    public static final Predicate<IBlockState> NETHERRACK = BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL);
    public static final Predicate<IBlockState> ENDSTONE = BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs);

    public static FeatureWorldGenMinable newOreGenerator(String name, int times, int maxY, int clusterSize, IBlockState state, Predicate<IBlockState> predicate) {
        return FeatureWorldGenMinable.newOreGenerator(name, clusterSize, times, state, predicate).setMaxY(maxY);
    }

    public static FeatureWorldGenMinable newOreGenerator(String name, int times, int clusterSize, IBlockState state, Predicate<IBlockState> predicate) {
        return new FeatureWorldGenMinable(name, times, new WorldGenMinable(state, clusterSize, predicate));
    }

    public static FeatureWorldGenMinable wrap(String name, int times, WorldGenMinable worldGenMinable) {
        return new FeatureWorldGenMinable(name, times, worldGenMinable);
    }

    public FeatureWorldGenMinable(String name, int times, WorldGenMinable worldGenMinable) {
        super(name, times, (WorldGenerator)worldGenMinable);
    }

    public FeatureWorldGenMinable setClusterSize(int newSize) {
        this.worldGenMinable = new WorldGenMinable(((WorldGenMinable)this.worldGenMinable).field_175920_a, Math.min(newSize, this.getMaxClusterSize()), ((WorldGenMinable)this.worldGenMinable).field_175919_c);
        return this;
    }

    @Override
    public FeatureWorldGenMinable setTimes(int maxY) {
        return (FeatureWorldGenMinable)super.setTimes(maxY);
    }

    @Override
    public FeatureWorldGenMinable setGenerationMultiplier(float multiplier) {
        return (FeatureWorldGenMinable)super.setGenerationMultiplier(multiplier);
    }

    @Override
    public FeatureWorldGenMinable setMaxY(int maxY) {
        return (FeatureWorldGenMinable)super.setMaxY(maxY);
    }

    @Override
    public FeatureWorldGenMinable setShouldGen(boolean shouldGen) {
        return (FeatureWorldGenMinable)super.setShouldGen(shouldGen);
    }

    protected int getMaxClusterSize() {
        return 30;
    }

    @Override
    public void reconfigure(Configuration config) {
        super.reconfigure(config);
        int old = ((WorldGenMinable)this.worldGenMinable).field_76541_b;
        int size = config.getInt("clusterSize", this.getConfigCategoryName(), old, 0, this.getMaxClusterSize(), "Sets the max cluster size.");
        if (size != old) {
            this.setClusterSize(size);
        }
    }
}

