/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import elec332.core.util.IElecItemHandler;
import elec332.core.util.InventoryHelper;
import elec332.core.util.ItemStackHelper;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class WrappedItemHandler
implements IElecItemHandler {
    public static IItemHandlerModifiable wrap(final @Nonnull IItemHandler itemHandler, final boolean in, final boolean out) {
        return new WrappedItemHandler(){

            @Override
            @Nonnull
            protected IItemHandler getItemHandler() {
                return itemHandler;
            }

            @Override
            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return in ? super.insertItem(slot, stack, simulate) : stack;
            }

            @Override
            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return out ? super.extractItem(slot, amount, simulate) : ItemStackHelper.NULL_STACK;
            }
        };
    }

    public static IItemHandlerModifiable wrap(final IItemHandler itemHandler) {
        return new WrappedItemHandler(){

            @Override
            @Nonnull
            protected IItemHandler getItemHandler() {
                return itemHandler;
            }
        };
    }

    @Nonnull
    protected abstract IItemHandler getItemHandler();

    public int getSlots() {
        return this.getItemHandler().getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.getItemHandler().getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.getItemHandler().insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.getItemHandler().extractItem(slot, amount, simulate);
    }

    @Override
    public int getSlotLimit(int slot) {
        return InventoryHelper.getSlotStackLimit(this.getItemHandler(), slot);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (this.getItemHandler() instanceof IItemHandlerModifiable) {
            ((IItemHandlerModifiable)this.getItemHandler()).setStackInSlot(slot, stack);
            return;
        }
        throw new UnsupportedOperationException();
    }
}

