/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import elec332.core.api.annotations.AbstractionMarker;
import elec332.core.main.ElecCore;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OredictHelper {
    private static List<String> allOres = Lists.newArrayList();
    private static List<String> allIngots = Lists.newArrayList();
    private static List<String> allDusts = Lists.newArrayList();

    public static void initLists() {
        allDusts.clear();
        allIngots.clear();
        allOres.clear();
        String[] names = OreDictionary.getOreNames();
        for (int i = 0; i < names.length; ++i) {
            String s = names[i];
            if (s == null) {
                ElecCore.systemPrintDebug("Null ore for ID: " + i);
                continue;
            }
            if (s.startsWith("ore")) {
                allOres.add(s);
                continue;
            }
            if (s.startsWith("ingot")) {
                allIngots.add(s);
                continue;
            }
            if (!s.startsWith("dust")) continue;
            allDusts.add(s);
        }
    }

    public static List<String> getAllOres() {
        return ImmutableList.copyOf(allOres);
    }

    public static List<String> getAllIngots() {
        return ImmutableList.copyOf(allIngots);
    }

    public static List<String> getAllDusts() {
        return ImmutableList.copyOf(allDusts);
    }

    public static String concatOreName(String oreName) {
        return oreName.replace("ore", "");
    }

    public static String concatIngotName(String ingotName) {
        return ingotName.replace("ingot", "");
    }

    public static boolean isOre(ItemStack stack) {
        return OredictHelper.getOreIDs(stack).length > 0;
    }

    public static List<String> getOreNames(ItemStack stack) {
        ArrayList ret = Lists.newArrayList();
        for (int i : OredictHelper.getOreIDs(stack)) {
            ret.add(OreDictionary.getOreName((int)i));
        }
        return ret;
    }

    public static int[] getOreIDs(ItemStack stack) {
        return OreDictionary.getOreIDs((ItemStack)stack);
    }

    public static List<ItemStack> getOres(String name) {
        return OredictHelper.getOres(name, false);
    }

    @AbstractionMarker(value="getInventoryAbstraction")
    public static List<ItemStack> getOres(String name, boolean alwaysCreateEntry) {
        throw new UnsupportedOperationException();
    }

    static {
        OredictHelper.initLists();
    }
}

