/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.InjectedModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.relauncher.FMLInjectionData;

public class FMLUtil {
    private static ASMDataTable dataTable;
    private static LoadController lc;
    private static final Field eventMethods;
    private static final Field eventBus;
    private static final Field mainModBus;
    private static final Field mcEnabled;
    private static final Field wrappedContainer;

    public static Class<?> loadClass(String clazz) throws ClassNotFoundException {
        return Class.forName(clazz, true, (ClassLoader)FMLUtil.getLoader().getModClassLoader());
    }

    public static String getOwnerName(Class<?> clazz) {
        ModContainer mod = FMLUtil.getOwner(clazz);
        return mod == null ? "<unknown>" : mod.getModId();
    }

    public static String getMcVersion() {
        return (String)FMLInjectionData.data()[4];
    }

    @Nullable
    public static ModContainer getOwner(Class<?> clazz) {
        for (ModContainer modContainer : FMLUtil.getLoader().getActiveModList()) {
            if (!modContainer.getOwnedPackages().contains(clazz.getPackage().getName())) continue;
            return modContainer;
        }
        return null;
    }

    @Nullable
    public static ModContainer getModContainer(Object mod) {
        return mod instanceof ModContainer ? (ModContainer)mod : FMLCommonHandler.instance().findContainerFor(mod);
    }

    public static boolean isInModInitialisation() {
        return !FMLUtil.hasReachedState(LoaderState.AVAILABLE);
    }

    public static boolean hasReachedState(LoaderState state) {
        return FMLUtil.getLoader().hasReachedState(state);
    }

    @Nonnull
    public static Loader getLoader() {
        return Loader.instance();
    }

    @Nonnull
    public static ASMDataTable getASMDataTable() {
        if (dataTable == null) {
            try {
                Field f = ModAPIManager.class.getDeclaredField("dataTable");
                f.setAccessible(true);
                dataTable = (ASMDataTable)Preconditions.checkNotNull((Object)((ASMDataTable)f.get(ModAPIManager.INSTANCE)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return dataTable;
    }

    public static boolean hasFMLModContainer(ModContainer mc) {
        return mc instanceof FMLModContainer || mc instanceof InjectedModContainer && FMLUtil.hasFMLModContainer(FMLUtil.getWrappedContainer((InjectedModContainer)mc));
    }

    public static FMLModContainer getFMLModContainer(ModContainer mc) {
        if (mc instanceof FMLModContainer) {
            return (FMLModContainer)mc;
        }
        if (mc instanceof InjectedModContainer) {
            return FMLUtil.getFMLModContainer(FMLUtil.getWrappedContainer((InjectedModContainer)mc));
        }
        throw new IllegalArgumentException();
    }

    public static ModContainer getWrappedContainer(InjectedModContainer mc) {
        try {
            return (ModContainer)wrappedContainer.get(mc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerToModBus(FMLModContainer modContainer, Object o) {
        try {
            ((EventBus)eventBus.get(modContainer)).register(o);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isModEnabled(FMLModContainer mc) {
        try {
            return mcEnabled.getBoolean(mc);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public static EventBus getMainModBus() {
        try {
            return (EventBus)mainModBus.get(FMLUtil.getLoadController());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static LoadController getLoadController() {
        if (lc == null) {
            try {
                Field f = Loader.class.getDeclaredField("modController");
                f.setAccessible(true);
                lc = (LoadController)Preconditions.checkNotNull((Object)((LoadController)f.get(FMLUtil.getLoader())));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return lc;
    }

    @Nullable
    public static ModContainer findMod(String modId) {
        for (ModContainer mc : FMLUtil.getLoader().getActiveModList()) {
            if (!mc.getModId().equals(modId)) continue;
            return mc;
        }
        return null;
    }

    static {
        try {
            eventMethods = FMLModContainer.class.getDeclaredField("eventMethods");
            eventMethods.setAccessible(true);
            eventBus = FMLModContainer.class.getDeclaredField("eventBus");
            eventBus.setAccessible(true);
            mainModBus = LoadController.class.getDeclaredField("masterChannel");
            mainModBus.setAccessible(true);
            mcEnabled = FMLModContainer.class.getDeclaredField("enabled");
            mcEnabled.setAccessible(true);
            wrappedContainer = InjectedModContainer.class.getDeclaredField("wrappedContainer");
            wrappedContainer.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

