/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.module;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import elec332.core.api.discovery.ASMDataProcessor;
import elec332.core.api.discovery.IASMDataHelper;
import elec332.core.api.discovery.IASMDataProcessor;
import elec332.core.api.module.ElecModule;
import elec332.core.api.module.IDefaultModuleImplementations;
import elec332.core.api.module.IModuleContainer;
import elec332.core.api.module.IModuleController;
import elec332.core.api.module.IModuleInfo;
import elec332.core.api.module.IModuleManager;
import elec332.core.main.APIHandler;
import elec332.core.main.ElecCore;
import elec332.core.module.DefaultModuleInfo;
import elec332.core.module.DefaultWrappedModule;
import elec332.core.util.FMLUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.MissingModsException;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;

@APIHandler.StaticLoad
@ASMDataProcessor(value={LoaderState.PREINITIALIZATION})
public enum ModuleManager implements IASMDataProcessor,
IModuleManager
{
    INSTANCE;

    private static final IModuleController DEFAULT_CONTROLLER;
    private static final IDefaultModuleImplementations defaultImpl;
    private Set<IModuleContainer> activeModules;
    private Set<IModuleContainer> activeModules_;
    private Set<IModuleInfo> registeredModules = Sets.newHashSet();
    private Map<ResourceLocation, IModuleContainer> activeModuleNames;
    private Map<String, IModuleController> moduleControllers = Maps.newHashMap();
    private Set<String> erroredMods;
    private boolean locked;
    private boolean loaded;
    private IASMDataHelper asmData;
    private static final Method mcForce;

    private ModuleManager() {
        this.activeModules = Sets.newHashSet();
        this.activeModules_ = Collections.unmodifiableSet(this.activeModules);
        this.activeModuleNames = Maps.newHashMap();
        this.erroredMods = Sets.newHashSet();
    }

    @Override
    public void processASMData(IASMDataHelper asmData, LoaderState state) {
        this.asmData = asmData;
    }

    @Subscribe
    public void preInitLast(Object event) {
        if (event.getClass() != FMLPreInitializationEvent.class || this.loaded) {
            return;
        }
        for (ModContainer modContainer : Loader.instance().getActiveModList()) {
            Object modO = modContainer.getMod();
            if (!(modO instanceof IModuleController)) continue;
            IModuleController iModuleController = (IModuleController)modO;
            this.moduleControllers.put(modContainer.getModId(), iModuleController);
            iModuleController.registerAdditionalModules(INSTANCE::registerAdditionalModule);
        }
        this.locked = true;
        for (ASMDataTable.ASMData aSMData : this.asmData.getAnnotationList(ElecModule.class)) {
            IModuleController moduleController = this.getModuleController((String)aSMData.getAnnotationInfo().get("owner"));
            try {
                IModuleInfo iModuleInfo = moduleController.getModuleInfo(aSMData, defaultImpl);
                if (iModuleInfo == null || !iModuleInfo.alwaysEnabled() && !moduleController.isModuleEnabled(iModuleInfo.getName())) continue;
                this.registeredModules.add(iModuleInfo);
            }
            catch (Exception exception) {
                ElecCore.logger.error("Error fetching information for module " + aSMData.getAnnotationInfo().get("name") + " from mod " + aSMData.getAnnotationInfo().get("owner"));
                ElecCore.logger.error((Object)exception);
            }
        }
        HashMap names = Maps.newHashMap();
        for (Object mod : Loader.instance().getActiveModList()) {
            names.put(mod.getModId(), mod.getProcessedVersion());
        }
        ArrayList arrayList = Lists.newArrayList();
        for (IModuleInfo iModuleInfo : this.registeredModules) {
            boolean add = true;
            HashSet hashSet = Sets.newHashSet();
            List<ArtifactVersion> requirements = iModuleInfo.getModDependencies();
            for (ArtifactVersion artifactVersion : requirements) {
                ArtifactVersion ver = (ArtifactVersion)names.get(artifactVersion.getLabel());
                if (ver != null && artifactVersion.containsVersion(ver)) continue;
                if (!iModuleInfo.autoDisableIfRequirementsNotMet()) {
                    hashSet.add(artifactVersion);
                }
                add = false;
            }
            if (!hashSet.isEmpty()) {
                String s = "Module: " + iModuleInfo.getCombinedName().toString();
                throw new MissingModsException((Set)hashSet, s, s);
            }
            if (!add) continue;
            arrayList.add(iModuleInfo);
        }
        HashSet mNames = Sets.newHashSet();
        for (IModuleInfo module3 : arrayList) {
            mNames.add(module3.getCombinedName().toString());
        }
        ModContainer modContainer = FMLUtil.getLoader().activeModContainer();
        for (IModuleInfo iModuleInfo : arrayList) {
            boolean add = true;
            ArrayList missingModules = Lists.newArrayList();
            for (String s : iModuleInfo.getModuleDependencies()) {
                if (Strings.isNullOrEmpty((String)s) || mNames.contains(s)) continue;
                if (!iModuleInfo.autoDisableIfRequirementsNotMet()) {
                    missingModules.add(s);
                }
                add = false;
            }
            if (!missingModules.isEmpty()) {
                throw new RuntimeException("Module: " + iModuleInfo.getCombinedName() + " requires module(s) " + missingModules + " to be present.");
            }
            if (!add) continue;
            if (this.activeModuleNames.get(iModuleInfo.getCombinedName()) != null) {
                throw new RuntimeException("Found duplicate module name: " + iModuleInfo.getCombinedName());
            }
            try {
                ModContainer modContainer2 = FMLUtil.findMod(iModuleInfo.getOwner());
                if (modContainer2 == null) {
                    throw new IllegalStateException("Error finding owner mod for module: " + iModuleInfo.getCombinedName());
                }
                ModuleManager.setActiveContainer(modContainer2);
                IModuleContainer module_ = iModuleInfo.getModuleController().wrap(iModuleInfo, defaultImpl);
                ModuleManager.setActiveContainer(modContainer);
                if (module_ == null) continue;
                this.activeModules.add(module_);
                this.activeModuleNames.put(new ResourceLocation(iModuleInfo.getCombinedName().toString().toLowerCase()), module_);
                ElecCore.logger.info("Successfully registered module " + iModuleInfo.getName() + " from mod " + iModuleInfo.getOwner());
            }
            catch (Exception exception) {
                ElecCore.logger.error("Error registering module " + iModuleInfo.getName() + " from mod " + iModuleInfo.getOwner());
                ElecCore.logger.error((Object)exception);
            }
        }
        for (final IModuleContainer iModuleContainer : this.activeModules) {
            ModContainer mc = iModuleContainer.getOwnerMod();
            if (!FMLUtil.hasFMLModContainer(mc)) {
                throw new UnsupportedOperationException();
            }
            FMLUtil.registerToModBus(FMLUtil.getFMLModContainer(mc), new Object(){

                @Subscribe
                public void onEvent(Object event) {
                    try {
                        iModuleContainer.invokeEvent(event);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error invoking event on module " + iModuleContainer.getModule() + ", owned by: " + iModuleContainer.getOwnerMod(), e.getCause());
                    }
                }
            });
        }
        this.forEachModule(module -> {
            try {
                ((FMLEvent)event).applyModContainer(module.getOwnerMod());
                module.invokeEvent(event);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking FMLPreInitializationEvent on module " + module.getName() + ", owned by: " + module.getOwnerMod(), e.getCause());
            }
        });
        this.processModuleField(ElecModule.Instance.class, IModuleContainer::getModule);
        this.processModuleField(ElecModule.Network.class, new Function<IModuleContainer, Object>(){

            @Override
            public Object apply(IModuleContainer iModuleContainer) {
                return iModuleContainer.getHandler().getPacketHandler();
            }
        });
        this.loaded = true;
    }

    private void processModuleField(Class<? extends Annotation> clazz, Function<IModuleContainer, Object> function) {
        for (IModuleContainer module : this.activeModules) {
            for (Field field : module.getModule().getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(clazz)) continue;
                field.setAccessible(true);
                String name = "";
                try {
                    name = (String)clazz.getDeclaredMethod("value", new Class[0]).invoke((Object)field.getAnnotation(clazz), new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                IModuleContainer module_ = module;
                if (!Strings.isNullOrEmpty((String)name)) {
                    module_ = this.activeModuleNames.get(new ResourceLocation(name));
                }
                Object o = function.apply(module_);
                try {
                    field.set(module.getModule(), o);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void registerAdditionalModule(IModuleInfo module) {
        if (this.locked) {
            throw new IllegalStateException("Mod " + Loader.instance().activeModContainer().getModId() + " attempted to register a module too late!");
        }
        if (module == null) {
            return;
        }
        this.registeredModules.add(module);
    }

    @Override
    @Nonnull
    public Set<IModuleContainer> getActiveModules() {
        return this.activeModules_;
    }

    @Override
    @Nullable
    public IModuleContainer getActiveModule(ResourceLocation module) {
        return this.activeModuleNames.get(new ResourceLocation(module.toString().toLowerCase()));
    }

    private void forEachModule(Consumer<IModuleContainer> consumer) {
        ModContainer mc = FMLUtil.getLoader().activeModContainer();
        for (IModuleContainer module : this.activeModules) {
            ModuleManager.setActiveContainer(module.getOwnerMod());
            consumer.accept(module);
        }
        ModuleManager.setActiveContainer(mc);
    }

    @Override
    public void invokeEvent(final Object event) {
        if (!this.loaded) {
            throw new IllegalStateException();
        }
        this.forEachModule(new Consumer<IModuleContainer>(){

            @Override
            public void accept(IModuleContainer module) {
                try {
                    module.invokeEvent(event);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error invoking event of type: " + event.getClass().getCanonicalName() + " for module: " + module.getCombinedName(), e);
                }
            }
        });
    }

    @Nonnull
    private IModuleController getModuleController(String mod) {
        IModuleController ret = this.moduleControllers.get(mod);
        if (ret == null) {
            if (this.erroredMods.add(mod)) {
                ElecCore.logger.error("Mod: " + mod + " does not have a module controller!");
            }
            return DEFAULT_CONTROLLER;
        }
        return ret;
    }

    private static void setActiveContainer(ModContainer mc) {
        try {
            mcForce.invoke((Object)FMLUtil.getLoadController(), mc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        DEFAULT_CONTROLLER = new IModuleController(){

            @Override
            public boolean isModuleEnabled(String moduleName) {
                return true;
            }
        };
        defaultImpl = new IDefaultModuleImplementations(){

            @Override
            public IModuleInfo newDefaultModuleInfo(String owner, String name, String modDependencies, String moduleDependencies, boolean autoDisableIfRequirementsNotMet, boolean alwaysOn, String mainClazz, IModuleController moduleController) {
                return new DefaultModuleInfo(owner, name, modDependencies, moduleDependencies, autoDisableIfRequirementsNotMet, alwaysOn, mainClazz, moduleController);
            }

            @Override
            public IModuleContainer newDefaultModuleContainer(Object moduleInstance, IModuleInfo moduleInfo) {
                return new DefaultWrappedModule(moduleInstance, moduleInfo);
            }
        };
        try {
            mcForce = LoadController.class.getDeclaredMethod("forceActiveContainer", ModContainer.class);
            mcForce.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        APIHandler.INSTANCE.inject(INSTANCE, IModuleManager.class);
    }
}

