/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.main;

import com.google.common.eventbus.Subscribe;
import elec332.abstraction.manager.CompatASMHandler;
import elec332.core.api.IElecCoreMod;
import elec332.core.api.data.IExternalSaveHandler;
import elec332.core.api.module.IModuleController;
import elec332.core.api.network.ModNetworkHandler;
import elec332.core.api.registry.ISingleRegister;
import elec332.core.api.util.IDependencyHandler;
import elec332.core.api.util.IRightClickCancel;
import elec332.core.asm.ASMLoader;
import elec332.core.effects.AbilityHandler;
import elec332.core.grid.internal.GridEventHandler;
import elec332.core.grid.internal.GridEventInputHandler;
import elec332.core.handler.ModEventHandler;
import elec332.core.handler.TickHandler;
import elec332.core.inventory.window.WindowManager;
import elec332.core.main.ElecCoreDiscoverer;
import elec332.core.main.ElecCoreRegistrar;
import elec332.core.main.ElecModHandler;
import elec332.core.main.ModEventHooks;
import elec332.core.module.ModuleManager;
import elec332.core.network.IElecNetworkHandler;
import elec332.core.network.packets.PacketReRenderBlock;
import elec332.core.network.packets.PacketSyncWidget;
import elec332.core.network.packets.PacketTileDataToServer;
import elec332.core.network.packets.PacketWidgetDataToServer;
import elec332.core.proxies.CommonProxy;
import elec332.core.server.SaveHandler;
import elec332.core.server.ServerHelper;
import elec332.core.util.FMLUtil;
import elec332.core.util.InventoryHelper;
import elec332.core.util.LoadTimer;
import elec332.core.util.MCModInfo;
import elec332.core.util.OredictHelper;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.InjectedModContainer;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="eleccore", name="ElecCore", dependencies="after:forestry", acceptedMinecraftVersions="[1.10,)", version="1.7.431", useMetadata=true)
public class ElecCore
implements IModuleController,
IElecCoreMod,
IDependencyHandler {
    public static final String ElecCoreVersion = "1.7.431";
    public static final String MODID = "eleccore";
    public static final String MODNAME = "ElecCore";
    public static final String FORGE_VERSION = "13.19.1.2195";
    public static final String FORGE_VERSION_110 = "12.18.3.2239";
    @SidedProxy(clientSide="elec332.core.proxies.ClientProxy", serverSide="elec332.core.proxies.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="eleccore")
    public static ElecCore instance;
    @ModNetworkHandler
    public static IElecNetworkHandler networkHandler;
    public static TickHandler tickHandler;
    public static Logger logger;
    protected ElecCoreDiscoverer asmDataProcessor;
    private Configuration config;
    private LoadTimer loadTimer;
    private ModEventHandler modEventHandler;
    public static final boolean developmentEnvironment;
    public static boolean debug;
    public static boolean removeJSONErrors;
    public static boolean suppressSpongeIssues;

    @Mod.EventHandler
    public void construction(FMLConstructionEvent event) {
        logger = LogManager.getLogger((String)MODNAME);
        Launch.classLoader.registerTransformer(ASMLoader.class.getCanonicalName());
        ASMLoader.injectEarly(new CompatASMHandler());
        boolean reg = false;
        List mcl = FMLUtil.getLoader().getModList();
        for (int i = mcl.size() - 1; i >= 0; --i) {
            ModContainer mc = (ModContainer)mcl.get(i);
            if (FMLUtil.hasFMLModContainer(mc)) {
                FMLModContainer fmlMc = FMLUtil.getFMLModContainer(mc);
                ModEventHooks hook = new ModEventHooks(fmlMc);
                FMLUtil.registerToModBus(fmlMc, hook);
                if (mc.getMod() == this) {
                    hook.onConstuct(event);
                    if (i == mcl.size() - 1) {
                        this.onConstructionLast((FMLEvent)event);
                        reg = true;
                    }
                }
                if (reg) continue;
                if (FMLUtil.isModEnabled(fmlMc)) {
                    FMLUtil.registerToModBus(fmlMc, this);
                }
                reg = true;
                continue;
            }
            if (reg) continue;
            if (mc instanceof InjectedModContainer) {
                mc = FMLUtil.getWrappedContainer((InjectedModContainer)mc);
            }
            System.out.println("Last mod doesn't have a FMLModContainer, but it's ModContainer of " + mc.getClass());
        }
        FMLUtil.getMainModBus().register((Object)ModuleManager.INSTANCE);
    }

    @Subscribe
    public void onConstructionLast(FMLEvent e) {
        if (e instanceof FMLConstructionEvent) {
            this.asmDataProcessor = new ElecCoreDiscoverer();
            this.asmDataProcessor.identify(((FMLConstructionEvent)e).getASMHarvestedData());
            ElecModHandler.identifyMods();
            this.asmDataProcessor.process(LoaderState.CONSTRUCTING);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ElecModHandler.initAnnotations(event.getAsmData());
        this.loadTimer = new LoadTimer(logger, MODNAME);
        this.loadTimer.startPhase((FMLStateEvent)event);
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        tickHandler = new TickHandler();
        networkHandler.registerClientPacket(PacketSyncWidget.class);
        networkHandler.registerServerPacket(PacketTileDataToServer.class);
        networkHandler.registerServerPacket(PacketWidgetDataToServer.class);
        networkHandler.registerClientPacket(PacketReRenderBlock.class);
        MinecraftForge.EVENT_BUS.register((Object)tickHandler);
        this.config.load();
        debug = this.config.getBoolean("debug", "general", false, "Set to true to print debug info to the log.");
        removeJSONErrors = this.config.getBoolean("removeJsonExceptions", "client", true, "Set to true to remove all the Json model errors from the log.") && !developmentEnvironment;
        suppressSpongeIssues = this.config.getBoolean("supressSpongeIssues", "general", false, "Set to true to prevent multiblock crashes when Sponge is installed. WARNING: Unsupported, this may cause unexpected behaviour, use with caution!");
        ServerHelper.instance.load();
        MinecraftForge.EVENT_BUS.register((Object)new GridEventHandler());
        proxy.preInitRendering();
        this.asmDataProcessor.process(LoaderState.PREINITIALIZATION);
        this.loadTimer.endPhase((FMLStateEvent)event);
        this.modEventHandler.postEvent((FMLStateEvent)event);
        MCModInfo.createMCModInfoElec(event, "Provides core functionality for Elec's Mods", "-", "assets/elec332/logo.png", new String[]{"Elec332"});
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.loadTimer.startPhase((FMLStateEvent)event);
        if (this.config.hasChanged()) {
            this.config.save();
        }
        networkHandler.registerPacket(WindowManager.INSTANCE);
        ElecCoreRegistrar.dummyLoad();
        SaveHandler.INSTANCE.dummyLoad();
        AbilityHandler.instance.init();
        ElecModHandler.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        this.asmDataProcessor.process(LoaderState.INITIALIZATION);
        OredictHelper.initLists();
        this.modEventHandler.postEvent((FMLStateEvent)event);
        this.loadTimer.endPhase((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.loadTimer.startPhase((FMLStateEvent)event);
        this.asmDataProcessor.process(LoaderState.POSTINITIALIZATION);
        OredictHelper.initLists();
        proxy.postInitRendering();
        this.modEventHandler.postEvent((FMLStateEvent)event);
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent(priority=EventPriority.LOWEST)
            public void onItemRightClick(PlayerInteractEvent.RightClickBlock event) {
                ItemStack stack;
                if (event.getHand() == EnumHand.OFF_HAND && (stack = event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND)) != null && stack.func_77973_b() instanceof IRightClickCancel && ((IRightClickCancel)stack.func_77973_b()).cancelInteraction(stack)) {
                    event.setCanceled(true);
                    return;
                }
                stack = event.getItemStack();
                if (stack != null && stack.func_77973_b() instanceof IRightClickCancel && ((IRightClickCancel)stack.func_77973_b()).cancelInteraction(stack)) {
                    event.setCanceled(true);
                    InventoryHelper.fireOnItemUse(stack.func_77973_b(), event.getEntityPlayer(), event.getWorld(), event.getPos(), event.getHand(), event.getFace(), (float)event.getHitVec().field_72450_a, (float)event.getHitVec().field_72448_b, (float)event.getHitVec().field_72449_c);
                }
            }
        });
        this.loadTimer.endPhase((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        this.loadTimer.startPhase((FMLStateEvent)event);
        this.asmDataProcessor.process(LoaderState.AVAILABLE);
        OredictHelper.initLists();
        this.modEventHandler.postEvent((FMLStateEvent)event);
        this.loadTimer.endPhase((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        GridEventInputHandler.INSTANCE.reloadHandlers();
        this.modEventHandler.postEvent((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        this.modEventHandler.postEvent((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        this.modEventHandler.postEvent((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        this.modEventHandler.postEvent((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent event) {
        this.modEventHandler.postEvent((FMLStateEvent)event);
    }

    @Override
    public void registerSaveHandlers(ISingleRegister<IExternalSaveHandler> saveHandlerRegistry) {
        saveHandlerRegistry.register(ServerHelper.instance);
    }

    public static void systemPrintDebug(Object s) {
        if (debug) {
            System.out.println(s);
        }
    }

    @Override
    public boolean isModuleEnabled(String moduleName) {
        return true;
    }

    @Override
    public String getRequiredForgeVersion(String mcVersion) {
        return mcVersion.contains("1.10") ? FORGE_VERSION_110 : FORGE_VERSION;
    }

    public void setModEventHandler(ModEventHandler handler) {
        if (this.modEventHandler != null) {
            throw new IllegalStateException();
        }
        this.modEventHandler = handler;
    }

    static {
        debug = false;
        removeJSONErrors = true;
        suppressSpongeIssues = false;
        developmentEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }
}

