/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.json;

import com.google.common.collect.Lists;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import elec332.core.json.JsonHandler;
import elec332.core.util.MineTweakerHelper;
import elec332.core.util.NBTTypes;
import elec332.core.util.RegistryHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class ExtraTypeAdapters {
    public static final JsonHandler.ElecFactory<ItemStack> itemStack = new JsonHandler.ElecFactory<ItemStack>(){

        @Override
        public TypeAdapter<ItemStack> getTypeAdapter() {
            return new TypeAdapter<ItemStack>(){

                public void write(JsonWriter out, ItemStack value) throws IOException {
                    if (value == null) {
                        out.nullValue();
                        return;
                    }
                    out.beginObject();
                    out.name("name").value(MineTweakerHelper.getItemRegistryName(value));
                    out.name("count").value((long)value.field_77994_a);
                    out.name("damage").value((long)Items.field_151045_i.getDamage(value));
                    out.name("nbtTag");
                    JsonHandler.getGson().toJson((Object)value.func_77978_p(), NBTTagCompound.class, out);
                    out.endObject();
                }

                public ItemStack read(JsonReader in) throws IOException {
                    if (in.peek() == JsonToken.NULL) {
                        in.nextNull();
                        return null;
                    }
                    in.beginObject();
                    String name = "";
                    int count = 1;
                    int damage = 0;
                    NBTTagCompound tag = null;
                    while (in.hasNext()) {
                        String inName = in.nextName();
                        if (inName.equals("name")) {
                            name = in.nextString();
                            continue;
                        }
                        if (inName.equals("count")) {
                            count = in.nextInt();
                            continue;
                        }
                        if (inName.equals("damage")) {
                            damage = in.nextInt();
                            continue;
                        }
                        if (!inName.equals("nbtTag")) continue;
                        tag = (NBTTagCompound)JsonHandler.getGson().fromJson(in, NBTTagCompound.class);
                    }
                    in.endObject();
                    ItemStack ret = new ItemStack((Item)RegistryHelper.getItemRegistry().getObject(new ResourceLocation(name)), count, damage);
                    ret.func_77982_d(tag);
                    return ret;
                }
            };
        }

        @Override
        public Class<ItemStack> getFactoryClass() {
            return ItemStack.class;
        }
    };
    public static final JsonHandler.ElecFactory<NBTTagCompound> nbtTagCompound = new JsonHandler.ElecFactory<NBTTagCompound>(){

        @Override
        public TypeAdapter<NBTTagCompound> getTypeAdapter() {
            return new TypeAdapter<NBTTagCompound>(){

                public void write(JsonWriter out, NBTTagCompound value) throws IOException {
                    if (value == null) {
                        out.nullValue();
                        return;
                    }
                    NBTTagCompound tagCompound = value.func_74737_b();
                    out.beginObject();
                    for (Object obj : tagCompound.func_150296_c()) {
                        String s = (String)obj;
                        out.name(s);
                        this.handleOut(out, tagCompound.func_74781_a(s).func_74732_a(), tagCompound.func_74781_a(s));
                    }
                    out.endObject();
                }

                public NBTTagCompound read(JsonReader in) throws IOException {
                    if (in.peek() == JsonToken.NULL) {
                        in.nextNull();
                        return null;
                    }
                    NBTTagCompound ret = new NBTTagCompound();
                    in.beginObject();
                    while (in.hasNext()) {
                        String toAdd = in.nextName();
                        in.beginObject();
                        NBTBase tagToAdd = this.handleIn(in, NBTTypes.valueOf(in.nextName()));
                        in.endObject();
                        ret.func_74782_a(toAdd, tagToAdd);
                    }
                    in.endObject();
                    return ret;
                }

                private NBTBase handleIn(JsonReader in, NBTTypes type) throws IOException {
                    switch (type) {
                        case BYTE: {
                            return new NBTTagByte((byte)in.nextInt());
                        }
                        case SHORT: {
                            return new NBTTagShort((short)in.nextInt());
                        }
                        case INT: {
                            return new NBTTagInt(in.nextInt());
                        }
                        case LONG: {
                            return new NBTTagLong(in.nextLong());
                        }
                        case FLOAT: {
                            return new NBTTagFloat((float)in.nextDouble());
                        }
                        case DOUBLE: {
                            return new NBTTagDouble(in.nextDouble());
                        }
                        case BYTE_ARRAY: {
                            return new NBTTagByteArray((byte[])JsonHandler.getGson().fromJson(in, byte[].class));
                        }
                        case STRING: {
                            return new NBTTagString(in.nextString());
                        }
                        case LIST: {
                            ArrayList nbtList = Lists.newArrayList();
                            in.beginObject();
                            in.nextName();
                            in.beginArray();
                            while (in.hasNext()) {
                                in.beginObject();
                                nbtList.add(this.handleIn(in, NBTTypes.valueOf(in.nextName())));
                                in.endObject();
                            }
                            in.endArray();
                            in.endObject();
                            NBTTagList tagList = new NBTTagList();
                            for (NBTBase nbtBase : nbtList) {
                                tagList.func_74742_a(nbtBase);
                            }
                            return tagList;
                        }
                        case COMPOUND: {
                            return this.read(in);
                        }
                        case INT_ARRAY: {
                            return new NBTTagIntArray((int[])JsonHandler.getGson().fromJson(in, int[].class));
                        }
                        case END: {
                            ExtraTypeAdapters.crash();
                            return null;
                        }
                    }
                    ExtraTypeAdapters.crash();
                    return null;
                }

                private void handleOut(JsonWriter out, byte i, NBTBase nbtBase) throws IOException {
                    out.beginObject();
                    if (NBTTypes.BYTE.equals(i)) {
                        out.name(NBTTypes.BYTE.toString()).value((long)((NBTTagByte)nbtBase).func_150290_f());
                    } else if (NBTTypes.SHORT.equals(i)) {
                        out.name(NBTTypes.SHORT.toString()).value((long)((NBTTagShort)nbtBase).func_150289_e());
                    } else if (NBTTypes.INT.equals(i)) {
                        out.name(NBTTypes.INT.toString()).value((long)((NBTTagInt)nbtBase).func_150287_d());
                    } else if (NBTTypes.LONG.equals(i)) {
                        out.name(NBTTypes.LONG.toString()).value(((NBTTagLong)nbtBase).func_150291_c());
                    } else if (NBTTypes.FLOAT.equals(i)) {
                        out.name(NBTTypes.FLOAT.toString()).value((double)((NBTTagFloat)nbtBase).func_150288_h());
                    } else if (NBTTypes.DOUBLE.equals(i)) {
                        out.name(NBTTypes.DOUBLE.toString()).value(((NBTTagDouble)nbtBase).func_150286_g());
                    } else if (NBTTypes.BYTE_ARRAY.equals(i)) {
                        out.name(NBTTypes.BYTE_ARRAY.toString());
                        JsonHandler.getGson().toJson((Object)((NBTTagByteArray)nbtBase).func_150292_c(), byte[].class, out);
                    } else if (NBTTypes.STRING.equals(i)) {
                        out.name(NBTTypes.STRING.toString()).value(((NBTTagString)nbtBase).func_150285_a_());
                    } else if (NBTTypes.LIST.equals(i)) {
                        NBTTagList tagList = (NBTTagList)nbtBase;
                        out.name(NBTTypes.LIST.toString());
                        out.beginObject();
                        out.name("contents");
                        out.beginArray();
                        for (int j = 0; j < tagList.func_74745_c(); ++j) {
                            NBTBase nbt = tagList.func_74737_b().func_74744_a(j);
                            this.handleOut(out, nbt.func_74732_a(), nbt);
                        }
                        out.endArray();
                        out.endObject();
                    } else if (NBTTypes.COMPOUND.equals(i)) {
                        out.name(NBTTypes.COMPOUND.toString());
                        this.write(out, (NBTTagCompound)nbtBase);
                    } else if (NBTTypes.INT_ARRAY.equals(i)) {
                        out.name(NBTTypes.INT_ARRAY.toString());
                        JsonHandler.getGson().toJson((Object)((NBTTagIntArray)nbtBase).func_150302_c(), int[].class, out);
                    }
                    out.endObject();
                }
            };
        }

        @Override
        public Class<NBTTagCompound> getFactoryClass() {
            return NBTTagCompound.class;
        }
    };
    public static final JsonHandler.ElecFactory<Fluid> fluid = new JsonHandler.ElecFactory<Fluid>(){

        @Override
        public TypeAdapter<Fluid> getTypeAdapter() {
            return new TypeAdapter<Fluid>(){

                public void write(JsonWriter out, Fluid value) throws IOException {
                    if (value == null) {
                        out.nullValue();
                        return;
                    }
                    out.beginObject();
                    out.name("name").value(value.getName());
                    out.endObject();
                }

                public Fluid read(JsonReader in) throws IOException {
                    if (in.peek() == JsonToken.NULL) {
                        in.nextNull();
                        return null;
                    }
                    in.beginObject();
                    Fluid ret = null;
                    if (in.nextName().equals("name")) {
                        ret = FluidRegistry.getFluid((String)in.nextString());
                    }
                    in.endObject();
                    return ret;
                }
            };
        }

        @Override
        public Class<Fluid> getFactoryClass() {
            return Fluid.class;
        }
    };
    public static final List<JsonHandler.ElecFactory<?>> allFactories = Lists.newArrayList((Object[])new JsonHandler.ElecFactory[]{itemStack, nbtTagCompound, fluid});

    private static void crash() {
        throw new RuntimeException();
    }
}

