/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.handler;

import elec332.core.api.annotations.RegisterTile;
import elec332.core.api.discovery.ASMDataProcessor;
import elec332.core.api.registration.RegisteredTileEntity;
import elec332.core.handler.AbstractAnnotationProcessor;
import java.util.function.Consumer;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.registry.GameRegistry;

@ASMDataProcessor(value={LoaderState.INITIALIZATION})
public class InitAnnotationProcessor
extends AbstractAnnotationProcessor {
    @Override
    protected void registerProcesses() {
        this.registerDataProcessor(RegisterTile.class, new Consumer<ASMDataTable.ASMData>(){

            @Override
            public void accept(ASMDataTable.ASMData data) {
                try {
                    GameRegistry.registerTileEntity(Class.forName(data.getClassName()), (String)((String)data.getAnnotationInfo().get("name")));
                }
                catch (Exception e) {
                    AbstractAnnotationProcessor.logger.error("Error registering tile: " + data.getClassName());
                }
            }
        });
        this.registerDataProcessor(RegisteredTileEntity.class, new Consumer<ASMDataTable.ASMData>(){

            @Override
            public void accept(ASMDataTable.ASMData data) {
                try {
                    GameRegistry.registerTileEntity(Class.forName(data.getClassName()), (String)((String)data.getAnnotationInfo().get("value")));
                }
                catch (Exception e) {
                    AbstractAnnotationProcessor.logger.error("Error registering tile: " + data.getClassName());
                }
            }
        });
    }
}

