/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.explosion;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class AbstractExplosion
extends Explosion {
    private final World world;
    private final BlockPos location;

    public AbstractExplosion(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size, false, true);
        this.world = world;
        this.location = new BlockPos((int)this.field_77284_b, (int)this.field_77285_c, (int)this.field_77282_d);
    }

    public void explode() {
        ExplosionEvent.Start event = new ExplosionEvent.Start(this.world, (Explosion)this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            this.preExplode();
            this.doExplode();
            this.postExplode();
        }
    }

    protected abstract void preExplode();

    protected abstract void doExplode();

    protected abstract void postExplode();

    protected void damageEntities(float radius, float power) {
        if (!this.world.field_72995_K) {
            BlockPos minCoord = new BlockPos((Vec3i)this.location);
            float minR = -(radius *= 2.0f) - 1.0f;
            float maxR = radius + 1.0f;
            minCoord.func_177963_a((double)minR, (double)minR, (double)minR);
            BlockPos maxCoord = new BlockPos((Vec3i)this.location);
            maxCoord.func_177963_a((double)maxR, (double)maxR, (double)maxR);
            List allEntities = this.world.func_72872_a(EntityLiving.class, new AxisAlignedBB(minCoord, maxCoord));
            Collections.sort(allEntities, new Comparator<Entity>(){

                @Override
                public int compare(Entity o1, Entity o2) {
                    return (int)(AbstractExplosion.this.getDistance(o1) - AbstractExplosion.this.getDistance(o2));
                }
            });
            for (Entity entity : allEntities) {
                double distance = this.getDistance(entity) / (double)radius;
                if (!(distance <= 1.0)) continue;
                double xDifference = entity.field_70165_t - (double)this.location.func_177958_n();
                double yDifference = entity.field_70163_u - (double)this.location.func_177956_o();
                double zDifference = entity.field_70161_v - (double)this.location.func_177952_p();
                double d1 = MathHelper.func_76133_a((double)(xDifference * xDifference + yDifference * yDifference + zDifference * zDifference));
                xDifference /= d1;
                yDifference /= d1;
                zDifference /= d1;
                double density = this.world.func_72842_a(new Vec3d((double)this.location.func_177958_n(), (double)this.location.func_177956_o(), (double)this.location.func_177952_p()), entity.func_174813_aQ());
                double d2 = (1.0 - distance) * density;
                int damage = (int)((d2 * d2 + d2) / 2.0 * 8.0 * (double)power + 1.0);
                entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)damage);
                entity.field_70159_w += xDifference * d2;
                entity.field_70181_x += yDifference * d2;
                entity.field_70179_y += zDifference * d2;
            }
        }
    }

    private double getDistance(Entity entity) {
        return entity.func_70011_f((double)this.location.func_177958_n(), (double)this.location.func_177956_o(), (double)this.location.func_177952_p());
    }

    public final float getRadius() {
        return this.field_77280_f;
    }

    public final BlockPos getLocation() {
        return this.location;
    }

    public final World getWorld() {
        return this.world;
    }

    public void func_77278_a() {
    }

    public void func_77279_a(boolean p_77279_1_) {
    }
}

