/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import elec332.core.api.config.IConfigWrapper;
import elec332.core.api.config.IConfigurableElement;
import elec332.core.config.CategoryAsConfig;
import elec332.core.config.Configurable;
import elec332.core.java.ReflectionHelper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;

public class ConfigWrapper
implements IConfigWrapper {
    private Configuration configuration;
    private List<Object> instances;
    private boolean hasInit;
    private List<CategoryData> categoryDataList;
    private List<String> categories;
    private List<IConfigurableElement> configurableElements;

    public ConfigWrapper(Configuration configuration) {
        this.configuration = configuration;
        this.instances = Lists.newArrayList();
        this.hasInit = false;
        this.categoryDataList = Lists.newArrayList();
        this.categories = Lists.newArrayList();
        this.configurableElements = Lists.newArrayList();
    }

    @Override
    public void registerConfig(Object o) {
        if (this.hasInit) {
            throw new RuntimeException("You cannot register configs after init");
        }
        this.instances.add(o);
    }

    @Override
    @Nonnull
    public ConfigWrapper setCategoryData(String category, String description) {
        for (CategoryData cat : this.categoryDataList) {
            if (!category.equals(cat.getCategory())) continue;
            throw new IllegalArgumentException();
        }
        this.categoryDataList.add(new CategoryData(category, description));
        this.addRegisteredCategory(category);
        return this;
    }

    private void addRegisteredCategory(String category) {
        if (!this.categories.contains(category.toLowerCase())) {
            this.categories.add(category.toLowerCase());
        }
    }

    @Override
    @Nonnull
    public List<String> getRegisteredCategories() {
        return ImmutableList.copyOf(this.categories);
    }

    @Override
    public boolean hasBeenLoaded() {
        return this.hasInit;
    }

    @Override
    public void registerConfigWithInnerClasses(Object obj) {
        this.registerConfig(obj);
        for (Class clazz : Lists.reverse((List)Lists.newArrayList((Object[])obj.getClass().getDeclaredClasses()))) {
            if (clazz.isInterface()) continue;
            try {
                this.registerConfigWithInnerClasses(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException("Error registering config: " + clazz.getName());
            }
        }
    }

    @Override
    public void registerConfigurableElement(IConfigurableElement configurableElement) {
        this.configurableElements.add(configurableElement);
    }

    @Override
    @Nonnull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void refresh(boolean load) {
        if (load) {
            this.configuration.load();
        }
        if (!this.hasInit) {
            this.hasInit = true;
        }
        for (CategoryData categoryData : this.categoryDataList) {
            this.configuration.setCategoryComment(categoryData.getCategory(), categoryData.getDescription());
        }
        for (Object o : this.instances) {
            boolean oldAccess;
            Class<?> objClass = o.getClass();
            String classCategory = "general";
            if (objClass.isAnnotationPresent(Configurable.Class.class)) {
                Configurable.Class configClass = objClass.getAnnotation(Configurable.Class.class);
                if (configClass.inherit() == Configurable.Inherit.TRUE) {
                    Class[] classes = ReflectionHelper.getAllTillMainClass(objClass);
                    String s = "";
                    for (Class clazz : classes) {
                        if (!clazz.isAnnotationPresent(Configurable.Class.class)) continue;
                        if (!s.equals("")) {
                            s = s + ".";
                        }
                        String s1 = clazz.getAnnotation(Configurable.Class.class).category();
                        s = s + (s1.equals("general") ? clazz.getSimpleName() : s1);
                    }
                    classCategory = s;
                } else {
                    classCategory = configClass.category();
                }
                String comment = configClass.comment();
                if (!comment.equals("")) {
                    this.configuration.setCategoryComment(classCategory, comment);
                }
            }
            for (Field field : objClass.getDeclaredFields()) {
                try {
                    oldAccess = field.isAccessible();
                    field.setAccessible(true);
                    if (field.isAnnotationPresent(Configurable.class)) {
                        Configurable configurable = field.getAnnotation(Configurable.class);
                        Object oldValue = field.get(o);
                        String category = configurable.category();
                        if (category.equals("general")) {
                            category = classCategory;
                        }
                        this.addRegisteredCategory(category);
                        if (field.getType().isAssignableFrom(Integer.TYPE)) {
                            field.set(o, this.configuration.getInt(field.getName(), category, ((Integer)oldValue).intValue(), (int)configurable.minValue(), (int)configurable.maxValue(), configurable.comment()));
                        } else if (field.getType().isAssignableFrom(Boolean.TYPE)) {
                            field.set(o, this.configuration.getBoolean(field.getName(), category, ((Boolean)oldValue).booleanValue(), configurable.comment()));
                        } else if (field.getType().isAssignableFrom(String.class)) {
                            if (configurable.validStrings().length > 0) {
                                field.set(o, this.configuration.getString(field.getName(), category, (String)oldValue, configurable.comment(), configurable.validStrings()));
                            } else {
                                field.set(o, this.configuration.getString(field.getName(), category, (String)oldValue, configurable.comment()));
                            }
                        } else if (field.getType().isAssignableFrom(Float.TYPE)) {
                            field.set(o, Float.valueOf(this.configuration.getFloat(field.getName(), category, ((Float)oldValue).floatValue(), configurable.minValue(), configurable.maxValue(), configurable.comment())));
                        }
                    }
                    field.setAccessible(oldAccess);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            for (AccessibleObject accessibleObject : objClass.getDeclaredMethods()) {
                try {
                    oldAccess = accessibleObject.isAccessible();
                    ((Method)accessibleObject).setAccessible(true);
                    if (accessibleObject.isAnnotationPresent(Configurable.class) && ((Method)accessibleObject).getParameterTypes().length == 0) {
                        Configurable configurable = ((Method)accessibleObject).getAnnotation(Configurable.class);
                        if (this.configuration.getBoolean(((Method)accessibleObject).getName(), configurable.category(), configurable.enabledByDefault(), configurable.comment())) {
                            ((Method)accessibleObject).invoke(o, new Object[0]);
                        }
                    }
                    ((Method)accessibleObject).setAccessible(oldAccess);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }
        for (IConfigurableElement cfgElement : this.configurableElements) {
            cfgElement.reconfigure(this.configuration);
        }
        if (this.configuration.hasChanged()) {
            this.configuration.save();
        }
    }

    @Override
    @Nonnull
    public Configuration wrapCategoryAsConfig(String category) {
        return ConfigWrapper.wrapCategoryAsConfig(this.configuration, category);
    }

    public static Configuration wrapCategoryAsConfig(Configuration configuration, String category) {
        return new CategoryAsConfig(category, configuration);
    }

    private final class CategoryData {
        private final String category;
        private final String desc;

        private CategoryData(String category, String desc) {
            this.category = category;
            this.desc = desc;
        }

        private String getCategory() {
            return this.category;
        }

        private String getDescription() {
            return this.desc;
        }
    }
}

