/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.compat.forestry.bee;

import elec332.core.compat.forestry.ForestryAlleles;
import elec332.core.compat.forestry.IGenomeTemplate;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleArea;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IAlleleEffect;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleTolerance;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class BeeGenomeTemplate
implements IGenomeTemplate<IAlleleBeeSpecies> {
    private IAllele[] alleles = BeeGenomeTemplate.getDefaultTemplate();
    private static IAllele[] defaultTemplate;

    public BeeGenomeTemplate setSpecies(IAlleleBeeSpecies species) {
        this.setAllele(EnumBeeChromosome.SPECIES, (IAllele)species);
        return this;
    }

    public BeeGenomeTemplate setSpeed(IAlleleFloat speed) {
        this.setAllele(EnumBeeChromosome.SPEED, (IAllele)speed);
        return this;
    }

    public BeeGenomeTemplate setLifeSpan(IAlleleInteger lifeSpan) {
        this.setAllele(EnumBeeChromosome.LIFESPAN, (IAllele)lifeSpan);
        return this;
    }

    public BeeGenomeTemplate setFertility(IAlleleInteger fertility) {
        this.setAllele(EnumBeeChromosome.FERTILITY, (IAllele)fertility);
        return this;
    }

    public BeeGenomeTemplate setTemperatureTolerance(IAlleleTolerance temperatureTolerance) {
        this.setAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAllele)temperatureTolerance);
        return this;
    }

    public BeeGenomeTemplate setNeverSleeps(IAlleleBoolean neverSleeps) {
        this.setAllele(EnumBeeChromosome.NEVER_SLEEPS, (IAllele)neverSleeps);
        return this;
    }

    public BeeGenomeTemplate setHumidityTolerance(IAlleleTolerance humidityTolerance) {
        this.setAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAllele)humidityTolerance);
        return this;
    }

    public BeeGenomeTemplate setToleratesRain(IAlleleBoolean toleratesRain) {
        this.setAllele(EnumBeeChromosome.TOLERATES_RAIN, (IAllele)toleratesRain);
        return this;
    }

    public BeeGenomeTemplate setCaveDwelling(IAlleleBoolean caveDwelling) {
        this.setAllele(EnumBeeChromosome.CAVE_DWELLING, (IAllele)caveDwelling);
        return this;
    }

    public BeeGenomeTemplate setFlowerProvider(IAlleleFlowers flowerProvider) {
        this.setAllele(EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)flowerProvider);
        return this;
    }

    public BeeGenomeTemplate setFloweringSpeed(IAlleleInteger floweringSpeed) {
        this.setAllele(EnumBeeChromosome.FLOWERING, (IAllele)floweringSpeed);
        return this;
    }

    public BeeGenomeTemplate setTerritory(IAlleleArea territory) {
        this.setAllele(EnumBeeChromosome.TERRITORY, (IAllele)territory);
        return this;
    }

    public BeeGenomeTemplate setEffect(IAlleleEffect effect) {
        this.setAllele(EnumBeeChromosome.EFFECT, (IAllele)effect);
        return this;
    }

    @Override
    @Nonnull
    public BeeGenomeTemplate copy() {
        BeeGenomeTemplate ret = new BeeGenomeTemplate();
        System.arraycopy(this.alleles, 0, ret.alleles, 0, this.alleles.length);
        return ret;
    }

    @Override
    @Nonnull
    public IAllele[] getAlleles() {
        return this.alleles;
    }

    @Override
    public IAlleleBeeSpecies getSpecies(IAllele[] alleles) {
        return (IAlleleBeeSpecies)alleles[EnumBeeChromosome.SPECIES.ordinal()];
    }

    private void setAllele(EnumBeeChromosome chromosome, IAllele allele) {
        this.alleles[chromosome.ordinal()] = allele;
    }

    private static IAllele[] getDefaultTemplate() {
        if (defaultTemplate == null) {
            defaultTemplate = new IAllele[EnumBeeChromosome.values().length];
            BeeGenomeTemplate.defaultTemplate[EnumBeeChromosome.SPEED.ordinal()] = ForestryAlleles.SPEED_SLOWEST;
            BeeGenomeTemplate.defaultTemplate[EnumBeeChromosome.LIFESPAN.ordinal()] = ForestryAlleles.LIFESPAN_SHORTER;
            BeeGenomeTemplate.defaultTemplate[EnumBeeChromosome.FERTILITY.ordinal()] = ForestryAlleles.FERTILITY_NORMAL;
            BeeGenomeTemplate.defaultTemplate[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = ForestryAlleles.TOLERANCE_NONE;
            BeeGenomeTemplate.defaultTemplate[EnumBeeChromosome.NEVER_SLEEPS.ordinal()] = ForestryAlleles.FALSE_RECESSIVE;
            BeeGenomeTemplate.defaultTemplate[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = ForestryAlleles.TOLERANCE_NONE;
            BeeGenomeTemplate.defaultTemplate[EnumBeeChromosome.TOLERATES_RAIN.ordinal()] = ForestryAlleles.FALSE_RECESSIVE;
            BeeGenomeTemplate.defaultTemplate[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = ForestryAlleles.FALSE_RECESSIVE;
            BeeGenomeTemplate.defaultTemplate[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = ForestryAlleles.FLOWERS_VANILLA;
            BeeGenomeTemplate.defaultTemplate[EnumBeeChromosome.FLOWERING.ordinal()] = ForestryAlleles.FLOWERING_SLOWEST;
            BeeGenomeTemplate.defaultTemplate[EnumBeeChromosome.TERRITORY.ordinal()] = ForestryAlleles.TERRITORY_AVERAGE;
            BeeGenomeTemplate.defaultTemplate[EnumBeeChromosome.EFFECT.ordinal()] = ForestryAlleles.EFFECT_NONE;
        }
        return Arrays.copyOf(defaultTemplate, defaultTemplate.length);
    }
}

