/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.compat.forestry.allele;

import elec332.core.compat.forestry.allele.AlleleEffect;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import net.minecraft.util.ResourceLocation;

public abstract class AlleleEffectThrottled
extends AlleleEffect {
    private int throttle = 20;
    protected boolean requiresWorkingQueen = false;

    public AlleleEffectThrottled(ResourceLocation rl) {
        super(rl);
    }

    public AlleleEffectThrottled(String s) {
        super(s);
    }

    public AlleleEffectThrottled(String uid, String unlocalizedName) {
        super(uid, unlocalizedName);
    }

    public AlleleEffectThrottled setThrottle(int throttle) {
        this.throttle = throttle;
        return this;
    }

    public AlleleEffectThrottled setRequiresWorkingQueen() {
        this.requiresWorkingQueen = true;
        return this;
    }

    @Override
    public final IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        if (this.isThrottled(storedData, housing)) {
            return storedData;
        }
        return this.doEffectThrottled(genome, storedData, housing);
    }

    private boolean isThrottled(IEffectData storedData, IBeeHousing housing) {
        if (this.requiresWorkingQueen && housing.getErrorLogic().hasErrors()) {
            return true;
        }
        int time = storedData.getInteger(0);
        storedData.setInteger(0, ++time);
        if (time < this.throttle) {
            return true;
        }
        storedData.setInteger(0, 0);
        return false;
    }

    public abstract IEffectData doEffectThrottled(IBeeGenome var1, IEffectData var2, IBeeHousing var3);
}

