/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.model.loading.handler;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import elec332.core.api.client.model.loading.IModelHandler;
import elec332.core.api.client.model.loading.ModelHandler;
import elec332.core.client.model.RenderingRegistry;
import elec332.core.client.model.loading.INoBlockStateJsonBlock;
import elec332.core.client.model.loading.INoJsonBlock;
import elec332.core.client.model.loading.INoUnlistedBlockStateJsonBlock;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.block.model.WeightedBakedModel;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.MultiModelState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

@ModelHandler
public class BlockVariantModelHandler
implements IModelHandler {
    private final Map<ModelResourceLocation, IBlockState> blockResourceLocations = Maps.newHashMap();
    private final Set<ResourceLocation> uniqueNames = Sets.newHashSet();

    public BlockVariantModelHandler() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoader());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void getModelHandlers(List<?> list) {
    }

    @Override
    public void registerModels() {
        ModelManager modelManager = Minecraft.func_71410_x().field_175617_aL;
        for (Block block : RenderingRegistry.instance().getAllValidBlocks()) {
            if (!(block instanceof INoBlockStateJsonBlock) || block instanceof INoJsonBlock) continue;
            final ResourceLocation baseName = new ResourceLocation("varianthandled", block.getRegistryName().toString().replace(":", "_"));
            this.uniqueNames.add(baseName);
            modelManager.func_174954_c().func_178120_a().func_178447_a(block, (IStateMapper)new StateMapperBase(){

                @Nonnull
                protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
                    ModelResourceLocation mrl = new ModelResourceLocation(baseName, this.func_178131_a((Map)state.func_177228_b()));
                    BlockVariantModelHandler.this.blockResourceLocations.put(mrl, state);
                    return mrl;
                }
            });
        }
    }

    @Override
    public void cleanExceptions(Map<ResourceLocation, Exception> exceptionMap) {
        HashSet one = Sets.newHashSet();
        this.uniqueNames.forEach(exceptionMap::remove);
        block0: for (ResourceLocation resourceLocation : this.blockResourceLocations.keySet()) {
            Throwable ex = exceptionMap.remove(resourceLocation);
            if (ex == null) continue;
            while ((ex = ex.getCause()) != null) {
                if (!(ex instanceof FileNotFoundException)) continue;
                ResourceLocation fixed = this.getFixedLocation(resourceLocation);
                if (!one.add(resourceLocation)) continue;
                exceptionMap.put((ResourceLocation)new ModelResourceLocation(fixed, "all"), (Exception)new ModelLoaderRegistry.LoaderException("Exception loading model json for " + fixed, ex));
                continue block0;
            }
        }
    }

    @Override
    @Nonnull
    public Map<ModelResourceLocation, IBakedModel> registerBakedModels(java.util.function.Function<ModelResourceLocation, IBakedModel> bakedModelGetter) {
        return ImmutableMap.of();
    }

    private ResourceLocation getFixedLocation(ResourceLocation rl) {
        return new ResourceLocation(rl.func_110623_a().replace("_", ":"));
    }

    private class TextureOverrideData
    implements Serializable {
        private Map<String, Map<String, String>> textureOverrides;
        private transient Map<String, Map<String, Pair<ResourceLocation, ResourceLocation>>> processedTextureOverrides;
        private transient Set<ResourceLocation> allTextures;

        private TextureOverrideData() {
        }

        private HashMap<ResourceLocation, ResourceLocation> process(Map<String, String> data) {
            if (this.processedTextureOverrides == null) {
                this.process();
            }
            HashMap ret = Maps.newHashMap();
            for (String s : data.keySet()) {
                Pair<ResourceLocation, ResourceLocation> overrde;
                Map<String, Pair<ResourceLocation, ResourceLocation>> d;
                if (!this.textureOverrides.containsKey(s) || (d = this.processedTextureOverrides.get(s)) == null || (overrde = d.get(data.get(s))) == null) continue;
                ret.put(overrde.getLeft(), overrde.getRight());
            }
            return ret;
        }

        private void process() {
            this.processedTextureOverrides = Maps.newHashMap();
            this.allTextures = Sets.newHashSet();
            for (String prop : this.textureOverrides.keySet()) {
                Map<String, String> vl = this.textureOverrides.get(prop);
                if (vl == null || vl.isEmpty()) continue;
                for (String value : vl.keySet()) {
                    String override = vl.get(value);
                    String[] data = override.split("-");
                    if (data.length != 2) {
                        throw new RuntimeException(this.textureOverrides.toString());
                    }
                    HashMap or = this.processedTextureOverrides.get(prop);
                    if (or == null) {
                        or = Maps.newHashMap();
                        this.processedTextureOverrides.put(prop, or);
                    }
                    ResourceLocation r1 = new ResourceLocation(data[0]);
                    ResourceLocation r2 = new ResourceLocation(data[1]);
                    or.put(value, Pair.of((Object)r1, (Object)r2));
                    this.allTextures.add(r1);
                    this.allTextures.add(r2);
                }
            }
        }

        private Set<ResourceLocation> getAllTextures() {
            if (this.allTextures == null) {
                this.process();
            }
            return this.allTextures;
        }
    }

    private class TextureOverride
    implements Function<ResourceLocation, TextureAtlasSprite> {
        private final Map<ResourceLocation, ResourceLocation> data;

        private TextureOverride(Map<ResourceLocation, ResourceLocation> data) {
            this.data = data;
        }

        @Nullable
        public TextureAtlasSprite apply(@Nullable ResourceLocation input) {
            ResourceLocation actual = this.data.getOrDefault(input, input);
            return (TextureAtlasSprite)net.minecraftforge.client.model.ModelLoader.defaultTextureGetter().apply((Object)actual);
        }
    }

    private class ModelLoader
    implements ICustomModelLoader {
        private ModelLoader() {
        }

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation instanceof ModelResourceLocation && BlockVariantModelHandler.this.blockResourceLocations.keySet().contains(modelLocation);
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            if (!(modelLocation instanceof ModelResourceLocation)) {
                throw new RuntimeException();
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            IBlockState ibs = (IBlockState)BlockVariantModelHandler.this.blockResourceLocations.get(modelLocation);
            if (ibs == null) {
                throw new IllegalStateException();
            }
            Block block = ibs.func_177230_c();
            boolean unlProp = block instanceof INoUnlistedBlockStateJsonBlock && ((INoUnlistedBlockStateJsonBlock)block).hasTextureOverrideJson(ibs);
            final List variants = ((INoBlockStateJsonBlock)block).getVariantsFor(ibs).func_188114_a();
            final List data = variants.stream().map(variant -> {
                Pair nullRet = Pair.of((Object)variant, null);
                if (!unlProp) {
                    return nullRet;
                }
                ResourceLocation location = ((INoUnlistedBlockStateJsonBlock)block).getTextureOverridesJson(ibs, (Variant)variant);
                if (location == null) {
                    return nullRet;
                }
                try {
                    IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(location.func_110624_b(), "models/" + location.func_110623_a() + ".json"));
                    InputStreamReader reader = new InputStreamReader(iresource.func_110527_b(), Charsets.UTF_8);
                    Pair ret = Pair.of((Object)variant, (Object)gson.fromJson((Reader)reader, TextureOverrideData.class));
                    ((Reader)reader).close();
                    return ret;
                }
                catch (Exception e) {
                    System.out.println("Exception while loading texture overrides: " + location);
                    e.printStackTrace();
                    return nullRet;
                }
            }).collect(Collectors.toList());
            final ArrayList locations = Lists.newArrayList();
            final HashSet textures = Sets.newHashSet();
            final ArrayList models = Lists.newArrayList();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Pair vtp : data) {
                Variant v = (Variant)vtp.getLeft();
                TextureOverrideData t = (TextureOverrideData)vtp.getRight();
                ResourceLocation loc = v.func_188046_a();
                locations.add(loc);
                IModel model = loc.equals((Object)net.minecraftforge.client.model.ModelLoader.field_177604_a) ? ModelLoaderRegistry.getMissingModel() : ModelLoaderRegistry.getModel((ResourceLocation)loc);
                model = v.process(model);
                for (ResourceLocation location : model.getDependencies()) {
                    ModelLoaderRegistry.getModelOrMissing((ResourceLocation)location);
                }
                textures.addAll(model.getTextures());
                if (t != null) {
                    textures.addAll(t.getAllTextures());
                }
                models.add(model);
                builder.add((Object)Pair.of((Object)model, (Object)v.getState()));
            }
            if (models.size() == 0) {
                IModel missing = ModelLoaderRegistry.getMissingModel();
                models.add(missing);
                builder.add((Object)Pair.of((Object)missing, (Object)TRSRTransformation.identity()));
            }
            MultiModelState defaultState = new MultiModelState(builder.build());
            return new IModel((IModelState)defaultState){
                final /* synthetic */ IModelState val$defaultState;
                {
                    this.val$defaultState = iModelState;
                }

                public Collection<ResourceLocation> getDependencies() {
                    return ImmutableList.copyOf((Collection)locations);
                }

                public Collection<ResourceLocation> getTextures() {
                    return ImmutableSet.copyOf((Collection)textures);
                }

                public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
                    if (!Attributes.moreSpecific((VertexFormat)format, (VertexFormat)Attributes.DEFAULT_BAKED_FORMAT)) {
                        throw new IllegalArgumentException("Can't bake vanilla weighted models to the format that doesn't fit into the default one: " + format);
                    }
                    if (variants.size() == 1) {
                        IModel model = (IModel)models.get(0);
                        return ModelLoader.this.bakeModel(model, MultiModelState.getPartState((IModelState)state, (IModel)model, (int)0), format, (Function<ResourceLocation, TextureAtlasSprite>)bakedTextureGetter, (TextureOverrideData)((Pair)data.get(0)).getRight());
                    }
                    WeightedBakedModel.Builder builder = new WeightedBakedModel.Builder();
                    for (int i = 0; i < variants.size(); ++i) {
                        IModel model = (IModel)models.get(i);
                        IBakedModel bModel = ModelLoader.this.bakeModel(model, MultiModelState.getPartState((IModelState)state, (IModel)model, (int)i), format, (Function<ResourceLocation, TextureAtlasSprite>)bakedTextureGetter, (TextureOverrideData)((Pair)data.get(i)).getRight());
                        builder.func_177677_a(bModel, ((Variant)variants.get(i)).func_188047_d());
                    }
                    return builder.func_177676_a();
                }

                public IModelState getDefaultState() {
                    return this.val$defaultState;
                }
            };
        }

        public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        }

        private IBakedModel bakeModel(final IModel model, final IModelState state, final VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, final @Nullable TextureOverrideData tovd) {
            final IBakedModel base = model.bake(state, format, bakedTextureGetter);
            if (tovd == null) {
                return base;
            }
            return new IBakedModel(){
                Map<IBlockState, IBakedModel> cache = new WeakHashMap<IBlockState, IBakedModel>();

                @Nonnull
                public List<BakedQuad> func_188616_a(@Nullable IBlockState blockState, @Nullable EnumFacing side, long rand) {
                    if (blockState == null) {
                        return base.func_188616_a(null, side, rand);
                    }
                    if (this.cache.containsKey(blockState)) {
                        return this.cache.get(blockState).func_188616_a(blockState, side, rand);
                    }
                    HashMap data = Maps.newHashMap();
                    ((INoUnlistedBlockStateJsonBlock)blockState.func_177230_c()).addAdditionalData(blockState, data);
                    if (data.isEmpty()) {
                        this.cache.put(blockState, base);
                    }
                    IBakedModel ret = model.bake(state, format, (Function)new TextureOverride(tovd.process(data)));
                    this.cache.put(blockState, ret);
                    return ret.func_188616_a(blockState, side, rand);
                }

                public boolean func_177555_b() {
                    return base.func_177555_b();
                }

                public boolean func_177556_c() {
                    return base.func_177556_c();
                }

                public boolean func_188618_c() {
                    return base.func_188618_c();
                }

                @Nonnull
                public TextureAtlasSprite func_177554_e() {
                    return base.func_177554_e();
                }

                @Nonnull
                public ItemCameraTransforms func_177552_f() {
                    return base.func_177552_f();
                }

                @Nonnull
                public ItemOverrideList func_188617_f() {
                    return base.func_188617_f();
                }
            };
        }
    }
}

