/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import elec332.core.api.client.IIconRegistrar;
import elec332.core.api.client.ITextureLoader;
import elec332.core.api.client.model.IElecModelBakery;
import elec332.core.api.client.model.IElecQuadBakery;
import elec332.core.api.client.model.IElecRenderingRegistry;
import elec332.core.api.client.model.IElecTemplateBakery;
import elec332.core.api.client.model.ModelLoadEvent;
import elec332.core.client.RenderHelper;
import elec332.core.client.model.loading.IModelAndTextureLoader;
import elec332.core.client.model.loading.IModelLoader;
import elec332.core.client.model.loading.handler.ElecModelHandler;
import elec332.core.java.ReflectionHelper;
import elec332.core.main.ElecCore;
import elec332.core.util.RegistryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class RenderingRegistry
implements IElecRenderingRegistry {
    private static final RenderingRegistry instance = new RenderingRegistry();
    private final Set<IModelLoader> modelLoaders = Sets.newHashSet();
    private final Set<ITextureLoader> textureLoaders = Sets.newHashSet();
    private final List<Item> extraItems = Lists.newArrayList();
    private final List<Block> extraBlocks = Lists.newArrayList();
    private final List<ModelResourceLocation> extraModels = Lists.newArrayList();

    public static RenderingRegistry instance() {
        return instance;
    }

    private RenderingRegistry() {
    }

    @Override
    public void registerLoadableModel(ModelResourceLocation mrl) {
        this.extraModels.add(mrl);
    }

    @Override
    public Item registerFakeItem(Item item) {
        this.extraItems.add(item);
        return item;
    }

    @Override
    public Block registerFakeBlock(Block block) {
        this.extraBlocks.add(block);
        return block;
    }

    @Override
    public void registerLoader(IModelLoader modelLoader) {
        this.registerLoader((Object)modelLoader);
    }

    @Override
    public void registerLoader(ITextureLoader textureLoader) {
        this.registerLoader((Object)textureLoader);
    }

    @Override
    public void registerLoader(IModelAndTextureLoader loader) {
        this.registerLoader((Object)loader);
    }

    @Override
    @Nonnull
    public Iterable<Block> getAllValidBlocks() {
        ArrayList list = Lists.newArrayList(RegistryHelper.getBlockRegistry());
        list.addAll(this.extraBlocks);
        return list;
    }

    @Override
    @Nonnull
    public Iterable<Item> getAllValidItems() {
        ArrayList list = Lists.newArrayList(RegistryHelper.getItemRegistry());
        list.addAll(this.extraItems);
        return list;
    }

    private void registerLoader(Object obj) {
        if (obj instanceof IModelLoader) {
            this.modelLoaders.add((IModelLoader)obj);
        }
        if (obj instanceof ITextureLoader) {
            this.textureLoaders.add((ITextureLoader)obj);
        }
    }

    void invokeEvent(TextureStitchEvent event) {
        IconRegistrar iconRegistrar = new IconRegistrar(event);
        for (ITextureLoader loader : this.textureLoaders) {
            loader.registerTextures(iconRegistrar);
        }
    }

    void invokeEvent(ModelLoadEvent event) {
        for (IModelLoader loader : this.modelLoaders) {
            loader.registerModels(event.getQuadBakery(), event.getModelBakery(), event.getTemplateBakery());
        }
    }

    void removeJsonErrors(ModelLoader modelLoader) {
        ElecCore.logger.info("Cleaning up internal Json stuff...");
        try {
            Set set = (Set)ReflectionHelper.makeFinalFieldModifiable(ModelLoader.class.getDeclaredField("missingVariants")).get(modelLoader);
            Map exceptionMap = (Map)ReflectionHelper.makeFinalFieldModifiable(ModelLoader.class.getDeclaredField("loadingExceptions")).get(modelLoader);
            if (ElecCore.removeJSONErrors) {
                exceptionMap.clear();
            }
            for (ModelResourceLocation rl : this.getValidLocations((ModelBakery)modelLoader)) {
                set.remove(rl);
                exceptionMap.remove(rl);
            }
            ElecModelHandler.cleanModelLoadingExceptions(exceptionMap);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        ElecCore.logger.info("Finished cleaning up internal Json stuff.");
    }

    private Set<ModelResourceLocation> getValidLocations(ModelBakery modelLoader) {
        IRegistry registry = modelLoader.field_177610_k.field_178128_c.field_174958_a;
        for (ModelResourceLocation mrl : this.extraModels) {
            IBakedModel model;
            try {
                IModel model_ = ModelLoaderRegistry.getModel((ResourceLocation)mrl);
                model = model_.bake(model_.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
            }
            catch (Exception e) {
                model = RenderHelper.getMissingModel();
            }
            registry.func_82595_a((Object)mrl, (Object)model);
        }
        return ElecModelHandler.registerBakedModels((IRegistry<ModelResourceLocation, IBakedModel>)registry);
    }

    static {
        instance.registerLoader(new IModelAndTextureLoader(){

            @Override
            public void registerModels(IElecQuadBakery quadBakery, IElecModelBakery modelBakery, IElecTemplateBakery templateBakery) {
                for (Item item : instance.getAllValidItems()) {
                    if (!(item instanceof IModelLoader)) continue;
                    ((IModelLoader)item).registerModels(quadBakery, modelBakery, templateBakery);
                }
                for (Block block : instance.getAllValidBlocks()) {
                    if (!(block instanceof IModelLoader)) continue;
                    ((IModelLoader)block).registerModels(quadBakery, modelBakery, templateBakery);
                }
            }

            @Override
            public void registerTextures(IIconRegistrar iconRegistrar) {
                for (Item item : instance.getAllValidItems()) {
                    if (!(item instanceof ITextureLoader)) continue;
                    ((ITextureLoader)item).registerTextures(iconRegistrar);
                }
                for (Block block : instance.getAllValidBlocks()) {
                    if (!(block instanceof ITextureLoader)) continue;
                    ((ITextureLoader)block).registerTextures(iconRegistrar);
                }
            }
        });
    }

    private class IconRegistrar
    implements IIconRegistrar {
        private final TextureMap textureMap;

        private IconRegistrar(TextureStitchEvent event) {
            this.textureMap = event.getMap();
        }

        @Override
        public TextureAtlasSprite registerSprite(ResourceLocation location) {
            this.textureMap.func_174942_a(location);
            return this.textureMap.func_110572_b(location.toString());
        }

        @Override
        public TextureMap getTextureMap() {
            return this.textureMap;
        }
    }
}

