/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.api;

import amerifrance.guideapi.api.ITypeReader;
import amerifrance.guideapi.api.impl.Book;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.RegistryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuideAPI {
    public static final IForgeRegistry<Book> BOOKS = new RegistryBuilder().setName(new ResourceLocation("guideapi", "books")).setType(Book.class).setIDRange(0, 1024).add((IForgeRegistry.AddCallback)new IForgeRegistry.AddCallback<Book>(){

        public void onAdd(Book obj, int id, Map<ResourceLocation, ?> slaveset) {
            LoaderState state = Loader.instance().getLoaderState();
            if (state == LoaderState.INITIALIZATION || state == LoaderState.POSTINITIALIZATION) {
                throw new RuntimeException(String.format("[Guide-API] Guides must be registered during %s. Please report this to %s.", LoaderState.PREINITIALIZATION.toString(), Loader.instance().activeModContainer().getModId()));
            }
        }
    }).create();
    private static final List<ITypeReader> TYPE_READERS = new ArrayList<ITypeReader>();
    public static Item guideBook;

    public static void addTypeReader(ITypeReader typeReader) {
        if (!TYPE_READERS.contains(typeReader)) {
            TYPE_READERS.add(typeReader);
        }
    }

    public static List<ITypeReader> getTypeReaders() {
        return new ArrayList<ITypeReader>(TYPE_READERS);
    }

    public static ItemStack getStackFromBook(Book book) {
        if (BOOKS.containsValue((IForgeRegistryEntry)book)) {
            return new ItemStack(guideBook, 1, BOOKS.getValues().indexOf((Object)book));
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setModel(Book book, ResourceLocation modelLoc, String variantName) {
        ModelLoader.setCustomModelResourceLocation((Item)guideBook, (int)BOOKS.getValues().indexOf((Object)book), (ModelResourceLocation)new ModelResourceLocation(modelLoc, variantName));
    }

    @SideOnly(value=Side.CLIENT)
    public static void setModel(Book book) {
        GuideAPI.setModel(book, new ResourceLocation("guideapi", "ItemGuideBook"), "inventory");
    }

    public static void initialize() {
    }
}

