/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.recipe;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import wanion.lib.recipe.RecipeHelper;
import wanion.unidict.common.Util;
import wanion.unidict.recipe.AbstractRecipeResearcher;

public class VanillaRecipeResearcher
extends AbstractRecipeResearcher<ShapedRecipes, ShapelessRecipes> {
    public int getShapedRecipeKey(@Nonnull ShapedRecipes recipe) {
        TIntList recipeKeys = Util.getList(recipe.field_77574_d, this.resourceHandler);
        int recipeKey = 0;
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    public int getShapelessRecipeKey(@Nonnull ShapelessRecipes recipe) {
        TIntList recipeKeys = Util.getList(recipe.field_77579_b.toArray(), this.resourceHandler);
        int recipeKey = 0;
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    @Nonnull
    public List<Class<? extends ShapedRecipes>> getShapedRecipeClasses() {
        return Collections.singletonList(ShapedRecipes.class);
    }

    @Nonnull
    public List<Class<? extends ShapelessRecipes>> getShapelessRecipeClasses() {
        return Collections.singletonList(ShapelessRecipes.class);
    }

    public ShapedOreRecipe getNewShapedRecipe(@Nonnull ShapedRecipes recipe) {
        Object[] newRecipeInputs = new Object[9];
        ItemStack[] recipeInputs = recipe.field_77574_d;
        int i = 0;
        if (itemStacksOnly) {
            for (int x = 0; x < recipe.field_77576_b; ++x) {
                for (int y = 0; y < recipe.field_77577_c; ++y) {
                    newRecipeInputs[y * 3 + x] = this.resourceHandler.getMainItemStack(recipeInputs[i++]);
                }
            }
        } else {
            for (int x = 0; x < recipe.field_77576_b; ++x) {
                for (int y = 0; y < recipe.field_77577_c; ++y) {
                    ItemStack input;
                    String bufferOreName;
                    newRecipeInputs[y * 3 + x] = (bufferOreName = this.resourceHandler.getContainerName(input = recipeInputs[i++])) != null ? bufferOreName : input;
                }
            }
        }
        return new ShapedOreRecipe(this.resourceHandler.getMainItemStack(recipe.func_77571_b()), RecipeHelper.rawShapeToShape((Object[])newRecipeInputs));
    }

    public ShapedOreRecipe getNewShapedFromShapelessRecipe(@Nonnull ShapelessRecipes recipe) {
        Object[] newRecipeInputs = new Object[9];
        List recipeInputs = recipe.field_77579_b;
        if (itemStacksOnly) {
            for (int i = 0; i < recipeInputs.size(); ++i) {
                newRecipeInputs[i] = this.resourceHandler.getMainItemStack((ItemStack)recipeInputs.get(i));
            }
        } else {
            for (int i = 0; i < recipeInputs.size(); ++i) {
                String bufferOreName = this.resourceHandler.getContainerName((ItemStack)recipeInputs.get(i));
                newRecipeInputs[i] = bufferOreName != null ? bufferOreName : recipeInputs.get(i);
            }
        }
        return new ShapedOreRecipe(this.resourceHandler.getMainItemStack(recipe.func_77571_b()), RecipeHelper.rawShapeToShape((Object[])newRecipeInputs));
    }

    public ShapelessOreRecipe getNewShapelessRecipe(@Nonnull ShapelessRecipes recipe) {
        ArrayList inputs = new ArrayList();
        if (itemStacksOnly) {
            recipe.field_77579_b.forEach(itemStack -> {
                if (itemStack != null) {
                    inputs.add(this.resourceHandler.getMainItemStack((ItemStack)itemStack));
                }
            });
        } else {
            recipe.field_77579_b.forEach(itemStack -> {
                if (itemStack != null) {
                    String bufferOreName = this.uniOreDictionary.getName(itemStack);
                    inputs.add(bufferOreName != null ? bufferOreName : itemStack);
                }
            });
        }
        return new ShapelessOreRecipe(this.resourceHandler.getMainItemStack(recipe.func_77571_b()), inputs.toArray());
    }

    public ShapelessOreRecipe getNewShapelessFromShapedRecipe(@Nonnull ShapedRecipes recipe) {
        ArrayList<Object> inputs = new ArrayList<Object>();
        if (itemStacksOnly) {
            for (ItemStack itemStack : recipe.field_77574_d) {
                if (itemStack == null) continue;
                inputs.add(this.resourceHandler.getMainItemStack(itemStack));
            }
        } else {
            for (ItemStack itemStack : recipe.field_77574_d) {
                if (itemStack == null) continue;
                String bufferOreName = this.uniOreDictionary.getName(itemStack);
                inputs.add(bufferOreName != null ? bufferOreName : itemStack);
            }
        }
        return new ShapelessOreRecipe(this.resourceHandler.getMainItemStack(recipe.func_77571_b()), inputs.toArray());
    }
}

