/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import com.raoulvdberge.refinedstorage.api.solderer.ISoldererRecipe;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.solderer.SoldererRecipeFluidStorage;
import com.raoulvdberge.refinedstorage.apiimpl.solderer.SoldererRecipePrintedProcessor;
import com.raoulvdberge.refinedstorage.apiimpl.solderer.SoldererRecipeProcessor;
import com.raoulvdberge.refinedstorage.apiimpl.solderer.SoldererRecipeStorage;
import com.raoulvdberge.refinedstorage.apiimpl.solderer.SoldererRecipeUpgrade;
import java.lang.reflect.Field;
import net.minecraft.item.ItemStack;
import wanion.unidict.UniDict;
import wanion.unidict.integration.AbstractIntegrationThread;

class RefinedStorageIntegration
extends AbstractIntegrationThread {
    private final Field soldererRecipeFluidStorageRows;
    private final Field soldererRecipePrintedProcessorRequirement;
    private final Field soldererRecipeProcessorRows;
    private final Field soldererRecipeStorageRows;
    private final Field soldererRecipeUpgradeRows;

    RefinedStorageIntegration() {
        super("Refined Storage");
        try {
            this.soldererRecipeFluidStorageRows = SoldererRecipeFluidStorage.class.getDeclaredField("rows");
            this.soldererRecipeFluidStorageRows.setAccessible(true);
            this.soldererRecipePrintedProcessorRequirement = SoldererRecipePrintedProcessor.class.getDeclaredField("requirement");
            this.soldererRecipePrintedProcessorRequirement.setAccessible(true);
            this.soldererRecipeProcessorRows = SoldererRecipeProcessor.class.getDeclaredField("rows");
            this.soldererRecipeProcessorRows.setAccessible(true);
            this.soldererRecipeStorageRows = SoldererRecipeStorage.class.getDeclaredField("rows");
            this.soldererRecipeStorageRows.setAccessible(true);
            this.soldererRecipeUpgradeRows = SoldererRecipeUpgrade.class.getDeclaredField("rows");
            this.soldererRecipeUpgradeRows.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Couldn't find the fields.");
        }
    }

    public String call() {
        try {
            this.fixRecipes();
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "Storing all the things.";
    }

    private void fixRecipes() throws IllegalAccessException {
        for (ISoldererRecipe soldererRecipe : API.instance().getSoldererRegistry().getRecipes()) {
            if (soldererRecipe instanceof SoldererRecipeFluidStorage) {
                this.resourceHandler.setMainItemStacks((Object[])this.soldererRecipeFluidStorageRows.get(soldererRecipe));
                continue;
            }
            if (soldererRecipe instanceof SoldererRecipePrintedProcessor) {
                this.soldererRecipePrintedProcessorRequirement.set(soldererRecipe, this.resourceHandler.getMainItemStack((ItemStack)this.soldererRecipePrintedProcessorRequirement.get(soldererRecipe)));
                continue;
            }
            if (soldererRecipe instanceof SoldererRecipeProcessor) {
                this.resourceHandler.setMainItemStacks((Object[])this.soldererRecipeProcessorRows.get(soldererRecipe));
                continue;
            }
            if (soldererRecipe instanceof SoldererRecipeStorage) {
                this.resourceHandler.setMainItemStacks((Object[])this.soldererRecipeStorageRows.get(soldererRecipe));
                continue;
            }
            if (!(soldererRecipe instanceof SoldererRecipeUpgrade)) continue;
            this.resourceHandler.setMainItemStacks((Object[])this.soldererRecipeUpgradeRows.get(soldererRecipe));
        }
    }
}

