/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;
import wanion.lib.common.Dependencies;
import wanion.lib.module.AbstractModule;
import wanion.lib.module.ModuleHandler;
import wanion.unidict.Config;
import wanion.unidict.UniOreDictionary;
import wanion.unidict.api.UniDictAPI;
import wanion.unidict.common.SpecificEntryItemStackComparator;
import wanion.unidict.common.SpecificKindItemStackComparator;
import wanion.unidict.integration.IntegrationModule;
import wanion.unidict.resource.ResourceHandler;
import wanion.unidict.resource.UniResourceHandler;

@Mod(modid="unidict", name="UniDict", version="1.10.2-2.9b", acceptedMinecraftVersions="[1.10.2]", dependencies="required-after:wanionlib@[1.10.2-1.3,);after:*")
public final class UniDict {
    @Mod.Instance(value="unidict")
    public static UniDict instance;
    private static Dependencies<IDependency> dependencies;
    private static Logger logger;
    private UniResourceHandler uniResourceHandler = UniResourceHandler.create();
    private ModuleHandler moduleHandler;

    public static Dependencies<IDependency> getDependencies() {
        return dependencies;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static ResourceHandler getResourceHandler() {
        return (ResourceHandler)dependencies.get(ResourceHandler.class);
    }

    public static UniOreDictionary getUniOreDictionary() {
        return (UniOreDictionary)dependencies.get(UniOreDictionary.class);
    }

    public static Config getConfig() {
        return (Config)dependencies.get(Config.class);
    }

    public static UniDictAPI getAPI() {
        return (UniDictAPI)dependencies.get(UniDictAPI.class);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        this.moduleHandler = this.searchForModules(this.populateModules(new ModuleHandler()), event.getAsmData());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.uniResourceHandler.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.uniResourceHandler.postInit();
        this.moduleHandler.startModules((FMLStateEvent)event);
        this.uniResourceHandler = null;
        this.moduleHandler = null;
        dependencies = null;
        SpecificKindItemStackComparator.kindSpecificComparators = null;
        SpecificEntryItemStackComparator.entrySpecificComparators = null;
    }

    private ModuleHandler populateModules(ModuleHandler moduleHandler) {
        Config config = UniDict.getConfig();
        if (!config.libraryMode && config.integrationModule) {
            moduleHandler.addModule((AbstractModule)new IntegrationModule());
        }
        return moduleHandler;
    }

    private ModuleHandler searchForModules(ModuleHandler moduleHandler, ASMDataTable asmDataTable) {
        Set modules = asmDataTable.getAll("wanion.unidict.UniDict$Module");
        modules.forEach(asmData -> {
            try {
                Class<?> mayBeAModule = Class.forName(asmData.getClassName());
                if (mayBeAModule.getSuperclass().isAssignableFrom(AbstractModule.class)) {
                    moduleHandler.addModule((AbstractModule)mayBeAModule.newInstance());
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error("Cannot load ", new Object[]{asmData.getClassName(), e});
            }
        });
        return moduleHandler;
    }

    @NetworkCheckHandler
    public boolean matchModVersions(Map<String, String> remoteVersions, Side side) {
        return side == Side.CLIENT ? remoteVersions.containsKey("unidict") : !remoteVersions.containsKey("unidict") || remoteVersions.get("unidict").equals("1.10.2-2.9b");
    }

    static {
        dependencies = new Dependencies();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Module {
    }

    public static interface IDependency {
    }
}

