/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.moreBees.item;

import forestry.api.apiculture.DefaultBeeModifier;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IHiveFrame;
import forestry.api.core.Tabs;
import forestry.core.items.ItemForestry;
import forestry.core.utils.Translator;
import java.util.List;
import lach_01298.moreBees.MoreBees;
import lach_01298.moreBees.item.ItemModelProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemFrame
extends ItemForestry
implements IHiveFrame,
ItemModelProvider {
    private final HiveFrameBeeModifier beeModifier;
    protected String name;

    public ItemFrame(int maxDamage, float geneticDecay, float production, float lifespan, float mutationRate, String name) {
        this.func_77625_d(1);
        this.func_77656_e(maxDamage);
        this.func_77637_a(Tabs.tabApiculture);
        this.beeModifier = new HiveFrameBeeModifier(geneticDecay, lifespan, mutationRate, production);
        this.name = name;
        this.func_77655_b("morebees." + name);
        this.setRegistryName(name);
    }

    public ItemStack frameUsed(IBeeHousing housing, ItemStack frame, IBee queen, int wear) {
        frame.func_77964_b(frame.func_77952_i() + wear);
        if (frame.func_77952_i() >= frame.func_77958_k()) {
            return null;
        }
        return frame;
    }

    public IBeeModifier getBeeModifier() {
        return this.beeModifier;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        this.beeModifier.addInformation(stack, playerIn, tooltip, advanced);
        if (!stack.func_77951_h()) {
            tooltip.add(Translator.translateToLocalFormatted((String)"item.for.durability", (Object[])new Object[]{stack.func_77958_k()}));
        }
    }

    @Override
    public void registerItemModel(Item item) {
        MoreBees.proxy.registerItemRenderer((Item)this, 0, this.name);
    }

    private static class HiveFrameBeeModifier
    extends DefaultBeeModifier {
        private final float geneticDecay;
        private final float lifespan;
        private final float mutationRate;
        private final float production;

        public HiveFrameBeeModifier(float geneticDecay, float lifespan, float mutationRate, float production) {
            this.geneticDecay = geneticDecay;
            this.lifespan = lifespan;
            this.mutationRate = mutationRate;
            this.production = production;
        }

        public float getProductionModifier(IBeeGenome genome, float currentModifier) {
            return this.production;
        }

        public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return this.mutationRate;
        }

        public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return this.lifespan;
        }

        public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
            return this.geneticDecay;
        }

        public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
            tooltip.add(Translator.translateToLocalFormatted((String)"item.for.bee.modifier.production", (Object[])new Object[]{Float.valueOf(this.production)}));
            tooltip.add(Translator.translateToLocalFormatted((String)"item.for.bee.modifier.genetic.decay", (Object[])new Object[]{Float.valueOf(this.geneticDecay)}));
            tooltip.add(Translator.translateToLocalFormatted((String)"item.for.bee.modifier.mutationModifier", (Object[])new Object[]{Float.valueOf(this.mutationRate)}));
            tooltip.add(Translator.translateToLocalFormatted((String)"item.for.bee.modifier.lifeSpanModifier", (Object[])new Object[]{Float.valueOf(this.lifespan)}));
        }
    }
}

