/*
 * Decompiled with CFR 0.152.
 */
package mods.belgabor.bitdrawers.block;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.config.PlayerConfigSetting;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import mod.chiselsandbits.api.IBitBag;
import mod.chiselsandbits.api.ItemType;
import mods.belgabor.bitdrawers.BitDrawers;
import mods.belgabor.bitdrawers.block.tile.TileBitController;
import mods.belgabor.bitdrawers.core.BDLogger;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockBitController
extends BlockController {
    public BlockBitController(String name) {
        super(name);
    }

    public TileBitController createNewTileEntity(World world, int meta) {
        return new TileBitController();
    }

    public EnumFacing getDirection(IBlockAccess blockAccess, BlockPos pos) {
        IBlockState state = blockAccess.func_180495_p(pos);
        EnumFacing facing = state != null ? (EnumFacing)state.func_177229_b((IProperty)FACING) : EnumFacing.NORTH;
        return facing != null ? facing : EnumFacing.NORTH;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (player.field_71075_bZ.field_75098_d) {
            float blockReachDistance = 0.0f;
            blockReachDistance = world.field_72995_K ? Minecraft.func_71410_x().field_71442_b.func_78757_d() + 1.0f : (float)((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() + 1.0f;
            RayTraceResult rayResult = ForgeHooks.rayTraceEyes((EntityLivingBase)player, (double)(blockReachDistance + 1.0f));
            if (this.getDirection((IBlockAccess)world, pos) == rayResult.field_178784_b) {
                this.func_180649_a(world, pos, player);
            } else {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
            }
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        ItemStack held;
        PlayerConfigSetting setting;
        if (world.field_72995_K) {
            return;
        }
        RayTraceResult ray = ForgeHooks.rayTraceEyes((EntityLivingBase)player, (double)(((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() + 1.0));
        EnumFacing side = ray.field_178784_b;
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("BlockBitController.onBlockClicked with " + ray.toString(), new Object[0]);
        }
        TileBitController tileDrawers = (TileBitController)this.getTileEntitySafe(world, pos);
        if (!SecurityManager.hasAccess((GameProfile)player.func_146103_bH(), (IProtectable)tileDrawers)) {
            return;
        }
        if (this.getDirection((IBlockAccess)world, pos).ordinal() != side.ordinal()) {
            return;
        }
        Map configSettings = (Map)ConfigManager.serverPlayerConfigSettings.get(player.func_110124_au());
        boolean invertShift = false;
        if (configSettings != null && (setting = (PlayerConfigSetting)configSettings.get("invertShift")) != null) {
            invertShift = (Boolean)setting.value;
        }
        if ((held = player.field_71071_by.func_70448_g()) == null && BitDrawers.config.debugTrace) {
            tileDrawers.updateCache();
        }
        ItemType heldType = BitDrawers.cnb_api.getItemType(held);
        IItemHandler handler = held == null ? null : (IItemHandler)held.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        ItemStack item = null;
        if (handler instanceof IBitBag) {
            IBitBag bag = (IBitBag)handler;
            int retrieved = tileDrawers.fillBag(bag, player.func_146103_bH());
            if (retrieved > 0 && !world.field_72995_K) {
                world.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            item = null;
        } else if (heldType != null && heldType.isBitAccess && heldType != ItemType.NEGATIVE_DESIGN) {
            item = tileDrawers.retrieveByPattern(held, player, player.func_70093_af() != invertShift);
        }
        IBlockState state = world.func_180495_p(pos);
        if (item != null && item.field_77994_a > 0) {
            if (!player.field_71071_by.func_70441_a(item)) {
                this.dropItemStack(world, pos.func_177972_a(side), player, item);
                world.func_184138_a(pos, state, state, 3);
            } else if (!world.field_72995_K) {
                world.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
    }

    protected void dropItemStack(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        EntityItem entity = new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.5f), stack);
        entity.func_70024_g(-entity.field_70159_w, -entity.field_70181_x, -entity.field_70179_y);
        world.func_72838_d((Entity)entity);
    }
}

