/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.BlockPosContext;
import net.minecraftforge.server.permission.context.IContext;
import reborncore.common.IWrenchable;
import reborncore.common.tile.TileMachineBase;
import techreborn.blocks.fluid.BlockFluidBase;
import techreborn.blocks.storage.BlockEnergyStorage;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.compat.CompatManager;
import techreborn.init.ModSounds;
import techreborn.items.ItemTRNoDestroy;
import techreborn.utils.IC2WrenchHelper;

public class ItemWrench
extends ItemTRNoDestroy {
    public ItemWrench() {
        this.func_77637_a(TechRebornCreativeTabMisc.instance);
        this.func_77655_b("techreborn.wrench");
        this.func_77625_d(1);
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        EnumActionResult result;
        if (!PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)"block.wrench", (IContext)new BlockPosContext(player, pos, world.func_180495_p(pos), side))) {
            return EnumActionResult.FAIL;
        }
        if (CompatManager.isIC2Loaded && (result = IC2WrenchHelper.onItemUseFirst(player.func_184586_b(hand), player, world, pos, side, hitX, hitY, hitZ, hand)) == EnumActionResult.SUCCESS) {
            return result;
        }
        if (world.func_175623_d(pos)) {
            return EnumActionResult.FAIL;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return EnumActionResult.FAIL;
        }
        if (!player.func_70093_af()) {
            if (tile instanceof TileMachineBase && side != EnumFacing.DOWN && side != EnumFacing.UP) {
                ((TileMachineBase)tile).setFacing(side);
                return EnumActionResult.SUCCESS;
            }
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof BlockEnergyStorage) {
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockEnergyStorage.FACING);
                facing = facing.func_176734_d() == side ? side : side.func_176734_d();
                world.func_175656_a(pos, state.func_177226_a((IProperty)BlockEnergyStorage.FACING, (Comparable)facing));
                return EnumActionResult.SUCCESS;
            }
        }
        return super.onItemUseFirst(stack, player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumActionResult result;
        if (!PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)"block.wrench", (IContext)new BlockPosContext(player, pos, world.func_180495_p(pos), facing))) {
            return EnumActionResult.FAIL;
        }
        if (CompatManager.isIC2Loaded && (result = IC2WrenchHelper.onItemUse(player.func_184586_b(hand), player, world, pos, hand, facing, hitX, hitY, hitZ)) == EnumActionResult.SUCCESS) {
            return result;
        }
        if (world.func_175623_d(pos)) {
            return EnumActionResult.FAIL;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return EnumActionResult.FAIL;
        }
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                if (tile instanceof IInventory) {
                    IInventory inventory = (IInventory)tile;
                    for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                        ItemStack itemStack = inventory.func_70301_a(i);
                        if (itemStack == null || itemStack.field_77994_a <= 0 || !(itemStack.func_77973_b() instanceof ItemBlock) || ((ItemBlock)itemStack.func_77973_b()).field_150939_a instanceof BlockFluidBase && ((ItemBlock)itemStack.func_77973_b()).field_150939_a instanceof BlockStaticLiquid && ((ItemBlock)itemStack.func_77973_b()).field_150939_a instanceof BlockDynamicLiquid) continue;
                        items.add(itemStack.func_77946_l());
                    }
                    if (tile instanceof IWrenchable) {
                        if (((IWrenchable)tile).wrenchCanRemove(player)) {
                            ItemStack itemStack = ((IWrenchable)tile).getWrenchDrop(player);
                            if (itemStack == null) {
                                return EnumActionResult.FAIL;
                            }
                            items.add(itemStack);
                        }
                        if (!items.isEmpty()) {
                            for (ItemStack itemStack : items) {
                                Random rand = new Random();
                                float dX = rand.nextFloat() * 0.8f + 0.1f;
                                float dY = rand.nextFloat() * 0.8f + 0.1f;
                                float dZ = rand.nextFloat() * 0.8f + 0.1f;
                                EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + dX), (double)((float)pos.func_177956_o() + dY), (double)((float)pos.func_177952_p() + dZ), itemStack.func_77946_l());
                                if (itemStack.func_77942_o()) {
                                    entityItem.func_92059_d().func_77982_d(itemStack.func_77978_p().func_74737_b());
                                }
                                float factor = 0.05f;
                                entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
                                entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
                                entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
                                if (world.field_72995_K) continue;
                                world.func_72838_d((Entity)entityItem);
                            }
                        }
                        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.BLOCK_DISMANTLE, SoundCategory.BLOCKS, 0.6f, 1.0f);
                        if (!world.field_72995_K) {
                            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                        }
                        return EnumActionResult.SUCCESS;
                    }
                }
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

