/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat;

import java.util.ArrayList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import techreborn.client.render.parts.ClientPartLoader;
import techreborn.compat.ICompatModule;
import techreborn.compat.ic2.RecipesIC2;
import techreborn.compat.minetweaker.MinetweakerCompat;
import techreborn.compat.theoneprobe.CompactTheOneProbe;
import techreborn.compat.tinkers.CompatModuleTinkers;
import techreborn.compat.waila.CompatModuleWaila;
import techreborn.config.ConfigTechReborn;
import techreborn.parts.StandalonePartCompact;
import techreborn.parts.TechRebornParts;
import techreborn.parts.walia.WailaMcMultiPartCompact;

public class CompatManager {
    public static CompatManager INSTANCE = new CompatManager();
    public static boolean isIC2Loaded = false;
    public static boolean isIC2ClassicLoaded = false;
    public static boolean isQuantumStorageLoaded = false;
    public ArrayList<ICompatModule> compatModules = new ArrayList();

    public CompatManager() {
        isIC2Loaded = Loader.isModLoaded((String)"IC2");
        isIC2ClassicLoaded = Loader.isModLoaded((String)"IC2-Classic-Spmod");
        isQuantumStorageLoaded = Loader.isModLoaded((String)"quantumstorage");
        this.register(MinetweakerCompat.class, "MineTweaker3");
        this.registerCompact(TechRebornParts.class, false, "reborncore-mcmultipart");
        this.registerCompact(ClientPartLoader.class, false, "reborncore-mcmultipart", "@client");
        this.registerCompact(StandalonePartCompact.class, false, "!reborncore-mcmultipart");
        this.registerCompact(WailaMcMultiPartCompact.class, false, "reborncore-mcmultipart", "Waila", "!IC2");
        this.register(CompatModuleWaila.class, "Waila");
        this.register(CompatModuleTinkers.class, "tconstruct");
        this.register(CompactTheOneProbe.class, "theoneprobe");
        this.register(RecipesIC2.class, "IC2");
    }

    public void register(Class<? extends ICompatModule> moduleClass, Object ... objs) {
        this.registerCompact(moduleClass, true, objs);
    }

    public void registerCompact(Class<? extends ICompatModule> moduleClass, boolean config, Object ... objs) {
        boolean shouldLoad = true;
        if (config) {
            shouldLoad = ConfigTechReborn.config.get(ConfigTechReborn.CATEGORY_INTEGRATION, "Compat:" + moduleClass.getSimpleName(), true, "Should the " + moduleClass.getSimpleName() + " be loaded?").getBoolean(true);
        }
        for (Object obj : objs) {
            if (obj instanceof String) {
                String modid = (String)obj;
                if (!(modid.startsWith("@") ? modid.equals("@client") && FMLCommonHandler.instance().getSide() != Side.CLIENT : (modid.startsWith("!") ? Loader.isModLoaded((String)modid.replaceAll("!", "")) : !Loader.isModLoaded((String)modid)))) continue;
                return;
            }
            if (!(obj instanceof Boolean)) continue;
            Boolean boo = (Boolean)obj;
            if (!boo.booleanValue()) {
                // empty if block
            }
            return;
        }
        if (config) {
            if (ConfigTechReborn.config.hasChanged()) {
                ConfigTechReborn.config.save();
            }
            if (!shouldLoad) {
                return;
            }
        }
        try {
            this.compatModules.add(moduleClass.newInstance());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

