/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.container.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.Pair;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerPlayerInventoryBuilder;
import techreborn.client.container.builder.ContainerTileInventoryBuilder;

public class ContainerBuilder {
    private final String name;
    private Predicate<EntityPlayer> canInteract = player -> true;
    final List<Slot> slots;
    final List<Range<Integer>> playerInventoryRanges;
    final List<Range<Integer>> tileInventoryRanges;
    final List<Pair<IntSupplier, IntConsumer>> shortValues;
    final List<Pair<IntSupplier, IntConsumer>> integerValues;
    final List<Consumer<InventoryCrafting>> craftEvents;

    public ContainerBuilder(String name) {
        this.name = name;
        this.slots = new ArrayList<Slot>();
        this.playerInventoryRanges = new ArrayList<Range<Integer>>();
        this.tileInventoryRanges = new ArrayList<Range<Integer>>();
        this.shortValues = new ArrayList<Pair<IntSupplier, IntConsumer>>();
        this.integerValues = new ArrayList<Pair<IntSupplier, IntConsumer>>();
        this.craftEvents = new ArrayList<Consumer<InventoryCrafting>>();
    }

    public ContainerBuilder interact(Predicate<EntityPlayer> canInteract) {
        this.canInteract = canInteract;
        return this;
    }

    public ContainerPlayerInventoryBuilder player(InventoryPlayer player) {
        return new ContainerPlayerInventoryBuilder(this, player);
    }

    public ContainerTileInventoryBuilder tile(IInventory tile) {
        return new ContainerTileInventoryBuilder(this, tile);
    }

    void addPlayerInventoryRange(Range<Integer> range) {
        this.playerInventoryRanges.add(range);
    }

    void addTileInventoryRange(Range<Integer> range) {
        this.tileInventoryRanges.add(range);
    }

    public BuiltContainer create() {
        BuiltContainer built = new BuiltContainer(this.name, this.canInteract, this.playerInventoryRanges, this.tileInventoryRanges);
        if (!this.shortValues.isEmpty()) {
            built.addShortSync(this.shortValues);
        }
        if (!this.integerValues.isEmpty()) {
            built.addIntegerSync(this.integerValues);
        }
        if (!this.craftEvents.isEmpty()) {
            built.addCraftEvents(this.craftEvents);
        }
        this.slots.forEach(built::addSlot);
        this.slots.clear();
        return built;
    }
}

