/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.playerprops;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mcjty.lib.varia.GlobalCoordinate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;

public class FavoriteDestinationsProperties {
    private Set<GlobalCoordinate> favoriteDestinations = new HashSet<GlobalCoordinate>();

    public void copyFrom(FavoriteDestinationsProperties source) {
        this.favoriteDestinations = new HashSet<GlobalCoordinate>(source.favoriteDestinations);
    }

    public boolean isDestinationFavorite(GlobalCoordinate coordinate) {
        return this.favoriteDestinations.contains(coordinate);
    }

    public void setDestinationFavorite(GlobalCoordinate coordinate, boolean favorite) {
        if (favorite) {
            this.favoriteDestinations.add(coordinate);
        } else {
            this.favoriteDestinations.remove(coordinate);
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        FavoriteDestinationsProperties.writeFavoritesToNBT(compound, this.favoriteDestinations);
    }

    private static void writeFavoritesToNBT(NBTTagCompound tagCompound, Collection<GlobalCoordinate> destinations) {
        NBTTagList lst = new NBTTagList();
        for (GlobalCoordinate destination : destinations) {
            NBTTagCompound tc = new NBTTagCompound();
            BlockPos c = destination.getCoordinate();
            tc.func_74768_a("x", c.func_177958_n());
            tc.func_74768_a("y", c.func_177956_o());
            tc.func_74768_a("z", c.func_177952_p());
            tc.func_74768_a("dim", destination.getDimension());
            lst.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("destinations", (NBTBase)lst);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.favoriteDestinations.clear();
        FavoriteDestinationsProperties.readCoordinatesFromNBT(compound, this.favoriteDestinations);
    }

    private static void readCoordinatesFromNBT(NBTTagCompound tagCompound, Set<GlobalCoordinate> destinations) {
        NBTTagList lst = tagCompound.func_150295_c("destinations", 10);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tc = lst.func_150305_b(i);
            BlockPos c = new BlockPos(tc.func_74762_e("x"), tc.func_74762_e("y"), tc.func_74762_e("z"));
            destinations.add(new GlobalCoordinate(c, tc.func_74762_e("dim")));
        }
    }
}

