/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.container.BaseSlot;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotFactory;
import mcjty.lib.container.SlotType;
import mcjty.lib.tools.InventoryTools;
import mcjty.lib.tools.ItemStackTools;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.blocks.storage.ModularStorageTileEntity;
import mcjty.rftools.blocks.storage.PacketSyncSlotsToClient;
import mcjty.rftools.craftinggrid.CraftingGridInventory;
import mcjty.rftools.items.storage.StorageFilterItem;
import mcjty.rftools.items.storage.StorageTypeItem;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class ModularStorageContainer
extends GenericContainer {
    public static final String CONTAINER_INVENTORY = "container";
    public static final String CONTAINER_GRID = "grid";
    public static final int SLOT_STORAGE_MODULE = 0;
    public static final int SLOT_TYPE_MODULE = 1;
    public static final int SLOT_FILTER_MODULE = 2;
    public static final int SLOT_STORAGE = 3;
    public static final int MAXSIZE_STORAGE = 300;
    private ModularStorageTileEntity modularStorageTileEntity;
    public static final ContainerFactory factory = new ContainerFactory(){

        protected void setup() {
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((Item)ModularStorageSetup.storageModuleItem)}), ModularStorageContainer.CONTAINER_INVENTORY, 0, 5, 157, 1, 18, 1, 18);
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, StorageTypeItem.class), ModularStorageContainer.CONTAINER_INVENTORY, 1, 5, 175, 1, 18, 1, 18);
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, StorageFilterItem.class), ModularStorageContainer.CONTAINER_INVENTORY, 2, 5, 193, 1, 18, 1, 18);
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_INPUT, new ItemStack[0]), ModularStorageContainer.CONTAINER_INVENTORY, 3, -500, -500, 30, 0, 10, 0);
            this.layoutPlayerInventorySlots(91, 157);
            this.layoutGridInventorySlots(CraftingGridInventory.GRID_XOFFSET, CraftingGridInventory.GRID_YOFFSET);
        }

        protected void layoutGridInventorySlots(int leftCol, int topRow) {
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_GHOST, new ItemStack[0]), ModularStorageContainer.CONTAINER_GRID, CraftingGridInventory.SLOT_GHOSTINPUT, leftCol, topRow, 3, 18, 3, 18);
            this.addSlotRange(new SlotDefinition(SlotType.SLOT_GHOSTOUT, new ItemStack[0]), ModularStorageContainer.CONTAINER_GRID, CraftingGridInventory.SLOT_GHOSTOUTPUT, leftCol, topRow += 58, 1, 18);
        }
    };

    public ModularStorageTileEntity getModularStorageTileEntity() {
        return this.modularStorageTileEntity;
    }

    public ModularStorageContainer(EntityPlayer player, IInventory containerInventory) {
        super(factory);
        this.modularStorageTileEntity = (ModularStorageTileEntity)containerInventory;
        this.addInventory(CONTAINER_INVENTORY, containerInventory);
        this.addInventory("player", (IInventory)player.field_71071_by);
        this.addInventory(CONTAINER_GRID, (IInventory)this.modularStorageTileEntity.getCraftingGrid().getCraftingGridInventory());
        this.generateSlots();
    }

    public void generateSlots() {
        for (SlotFactory slotFactory : factory.getSlots()) {
            Object slot;
            if (CONTAINER_GRID.equals(slotFactory.getInventoryName())) {
                SlotType slotType = slotFactory.getSlotType();
                IInventory inventory = (IInventory)this.inventories.get(slotFactory.getInventoryName());
                int index = slotFactory.getIndex();
                int x = slotFactory.getX();
                int y = slotFactory.getY();
                slot = this.createSlot(slotFactory, inventory, index, x, y, slotType);
            } else if (slotFactory.getSlotType() == SlotType.SLOT_SPECIFICITEM) {
                final SlotDefinition slotDefinition = slotFactory.getSlotDefinition();
                slot = new Slot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY()){

                    public boolean func_75214_a(ItemStack stack) {
                        return slotDefinition.itemStackMatches(stack);
                    }
                };
            } else {
                slot = slotFactory.getSlotType() == SlotType.SLOT_PLAYERINV || slotFactory.getSlotType() == SlotType.SLOT_PLAYERHOTBAR ? new BaseSlot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY()) : new BaseSlot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY()){

                    public boolean func_75216_d() {
                        if (this.getSlotIndex() >= ModularStorageContainer.this.modularStorageTileEntity.getMaxSize() + 3) {
                            return false;
                        }
                        return super.func_75216_d();
                    }

                    public ItemStack func_75211_c() {
                        if (this.getSlotIndex() >= ModularStorageContainer.this.modularStorageTileEntity.getMaxSize() + 3) {
                            return ItemStackTools.getEmptyStack();
                        }
                        return super.func_75211_c();
                    }

                    public boolean func_82869_a(EntityPlayer player) {
                        if (this.getSlotIndex() >= ModularStorageContainer.this.modularStorageTileEntity.getMaxSize() + 3) {
                            return false;
                        }
                        return super.func_82869_a(player);
                    }

                    public boolean func_75214_a(ItemStack stack) {
                        if (this.getSlotIndex() >= ModularStorageContainer.this.modularStorageTileEntity.getMaxSize() + 3) {
                            return false;
                        }
                        if (!ModularStorageContainer.this.modularStorageTileEntity.func_94041_b(this.getSlotIndex(), stack)) {
                            return false;
                        }
                        return super.func_75214_a(stack);
                    }
                };
            }
            this.func_75146_a((Slot)slot);
        }
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        super.func_75141_a(slotID, stack);
    }

    public ItemStack func_184996_a(int index, int button, ClickType mode, EntityPlayer player) {
        if (index == 0 && !player.func_130014_f_().field_72995_K) {
            this.modularStorageTileEntity.copyToModule();
        }
        return super.func_184996_a(index, button, mode, player);
    }

    public void func_75142_b() {
        ArrayList<Object> differentSlots = new ArrayList<Pair<Integer, ItemStack>>();
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            ItemStack itemstack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
            ItemStack itemstack1 = (ItemStack)InventoryTools.getContainerItemStacks((Container)this).get(i);
            if (ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            itemstack1 = ItemStackTools.isEmpty((ItemStack)itemstack) ? ItemStackTools.getEmptyStack() : itemstack.func_77946_l();
            InventoryTools.getContainerItemStacks((Container)this).set(i, itemstack1);
            differentSlots.add((Pair<Integer, ItemStack>)Pair.of((Object)i, (Object)itemstack));
            if (differentSlots.size() < 30) continue;
            this.syncSlotsToListeners(differentSlots);
            differentSlots = new ArrayList();
        }
        if (!differentSlots.isEmpty()) {
            this.syncSlotsToListeners(differentSlots);
        }
    }

    private void syncSlotsToListeners(List<Pair<Integer, ItemStack>> differentSlots) {
        String sortMode = this.modularStorageTileEntity.getSortMode();
        String viewMode = this.modularStorageTileEntity.getViewMode();
        boolean groupMode = this.modularStorageTileEntity.isGroupMode();
        String filter = this.modularStorageTileEntity.getFilter();
        for (IContainerListener listener : this.field_75149_d) {
            if (!(listener instanceof EntityPlayerMP)) continue;
            EntityPlayerMP player = (EntityPlayerMP)listener;
            RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketSyncSlotsToClient(this.modularStorageTileEntity.func_174877_v(), sortMode, viewMode, groupMode, filter, this.modularStorageTileEntity.getMaxSize(), this.modularStorageTileEntity.getNumStacks(), differentSlots), player);
        }
    }
}

