/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.RFTools;
import mcjty.rftools.api.screens.data.IModuleData;
import mcjty.rftools.api.screens.data.IModuleDataFactory;
import mcjty.rftools.blocks.screens.network.PacketGetScreenDataHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketReturnScreenData
implements IMessage {
    private GlobalCoordinate pos;
    private Map<Integer, IModuleData> screenData;

    public void fromBytes(ByteBuf buf) {
        this.pos = new GlobalCoordinate(NetworkTools.readPos((ByteBuf)buf), buf.readInt());
        int size = buf.readInt();
        this.screenData = new HashMap<Integer, IModuleData>(size);
        for (int i = 0; i < size; ++i) {
            int key = buf.readInt();
            int shortId = buf.readInt();
            String id = RFTools.screenModuleRegistry.getNormalId(shortId);
            IModuleDataFactory dataFactory = RFTools.screenModuleRegistry.getModuleDataFactory(id);
            Object data = dataFactory.createData(buf);
            this.screenData.put(key, (IModuleData)data);
        }
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos.getCoordinate());
        buf.writeInt(this.pos.getDimension());
        buf.writeInt(this.screenData.size());
        for (Map.Entry<Integer, IModuleData> me : this.screenData.entrySet()) {
            buf.writeInt(me.getKey().intValue());
            IModuleData c = me.getValue();
            buf.writeInt(RFTools.screenModuleRegistry.getShortId(c.getId()));
            c.writeToBuf(buf);
        }
    }

    public PacketReturnScreenData() {
    }

    public GlobalCoordinate getPos() {
        return this.pos;
    }

    public Map<Integer, IModuleData> getScreenData() {
        return this.screenData;
    }

    public PacketReturnScreenData(GlobalCoordinate pos, Map<Integer, IModuleData> screenData) {
        this.pos = pos;
        this.screenData = screenData;
    }

    public static class Handler
    implements IMessageHandler<PacketReturnScreenData, IMessage> {
        public IMessage onMessage(PacketReturnScreenData message, MessageContext ctx) {
            RFTools.proxy.addScheduledTaskClient(() -> PacketGetScreenDataHelper.setScreenData(message));
            return null;
        }
    }
}

