/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.counter;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.clientinfo.InfoPacketClient;
import mcjty.lib.network.clientinfo.InfoPacketServer;
import mcjty.rftools.blocks.logic.counter.CounterInfoPacketClient;
import mcjty.rftools.blocks.logic.counter.CounterTileEntity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class CounterInfoPacketServer
implements InfoPacketServer {
    private int dimension;
    private BlockPos pos;

    public CounterInfoPacketServer() {
    }

    public CounterInfoPacketServer(int dimension, BlockPos pos) {
        this.dimension = dimension;
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.pos = NetworkTools.readPos((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
    }

    public Optional<InfoPacketClient> onMessageServer(EntityPlayerMP player) {
        TileEntity te;
        WorldServer world = DimensionManager.getWorld((int)this.dimension);
        int cnt = -1;
        if (world != null && (te = world.func_175625_s(this.pos)) instanceof CounterTileEntity) {
            CounterTileEntity tileEntity = (CounterTileEntity)te;
            cnt = tileEntity.getCurrent();
        }
        return Optional.of(new CounterInfoPacketClient(cnt));
    }
}

