/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import mcjty.lib.base.ModBase;
import mcjty.lib.compat.CompatCreativeTabs;
import mcjty.lib.compat.MainCompatHandler;
import mcjty.lib.varia.Logging;
import mcjty.rftools.Achievements;
import mcjty.rftools.ClientInfo;
import mcjty.rftools.api.screens.IScreenModuleRegistry;
import mcjty.rftools.api.teleportation.ITeleportationManager;
import mcjty.rftools.apiimpl.ScreenModuleRegistry;
import mcjty.rftools.apiimpl.TeleportationManager;
import mcjty.rftools.blocks.blockprotector.BlockProtectors;
import mcjty.rftools.blocks.logic.wireless.RedstoneChannels;
import mcjty.rftools.blocks.powercell.PowerCellNetwork;
import mcjty.rftools.blocks.security.SecurityChannels;
import mcjty.rftools.blocks.storage.RemoteStorageIdRegistry;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.commands.CommandRftCfg;
import mcjty.rftools.commands.CommandRftDb;
import mcjty.rftools.commands.CommandRftTp;
import mcjty.rftools.integration.computers.OpenComputersIntegration;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.manual.GuiRFToolsManual;
import mcjty.rftools.proxy.CommonProxy;
import mcjty.rftools.wheelsupport.WheelSupport;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="rftools", name="RFTools", dependencies="required-after:mcjtylib_ng@[2.3.10,);required-after:compatlayer@[0.1.7,);before:xnet@[1.3.0,);after:Forge@[12.18.2.2116,);after:forge@[13.20.0.2266,)", version="6.13", acceptedMinecraftVersions="[1.10,1.12)")
public class RFTools
implements ModBase {
    public static final String MODID = "rftools";
    public static final String VERSION = "6.13";
    public static final String MIN_FORGE10_VER = "12.18.2.2116";
    public static final String MIN_FORGE11_VER = "13.20.0.2266";
    public static final String MIN_MCJTYLIB_VER = "2.3.10";
    public static final String MIN_XNET_VER = "1.3.0";
    public static final String COMPATLAYER_VER = "0.1.7";
    @SidedProxy(clientSide="mcjty.rftools.proxy.ClientProxy", serverSide="mcjty.rftools.proxy.ServerProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="rftools")
    public static RFTools instance;
    public boolean rftoolsDimensions = false;
    public boolean xnet = false;
    public static ScreenModuleRegistry screenModuleRegistry;
    private static int modGuiIndex;
    public ClientInfo clientInfo = new ClientInfo();
    public static CreativeTabs tabRfTools;
    public static final String SHIFT_MESSAGE = "<Press Shift>";
    public static final int GUI_MANUAL_MAIN;
    public static final int GUI_COALGENERATOR;
    public static final int GUI_CRAFTER;
    public static final int GUI_MODULAR_STORAGE;
    public static final int GUI_REMOTE_STORAGE;
    public static final int GUI_STORAGE_FILTER;
    public static final int GUI_REMOTE_STORAGE_ITEM;
    public static final int GUI_MODULAR_STORAGE_ITEM;
    public static final int GUI_REMOTE_STORAGESCANNER_ITEM;
    public static final int GUI_DIALING_DEVICE;
    public static final int GUI_MATTER_RECEIVER;
    public static final int GUI_MATTER_TRANSMITTER;
    public static final int GUI_ADVANCEDPORTER;
    public static final int GUI_TELEPORTPROBE;
    public static final int GUI_SCREEN;
    public static final int GUI_SCREENCONTROLLER;
    public static final int GUI_COUNTER;
    public static final int GUI_SEQUENCER;
    public static final int GUI_TIMER;
    public static final int GUI_THREE_LOGIC;
    public static final int GUI_MACHINE_INFUSER;
    public static final int GUI_BUILDER;
    public static final int GUI_SHAPECARD;
    public static final int GUI_CHAMBER_DETAILS;
    public static final int GUI_POWERCELL;
    public static final int GUI_RELAY;
    public static final int GUI_LIQUID_MONITOR;
    public static final int GUI_RF_MONITOR;
    public static final int GUI_SHIELD;
    public static final int GUI_ENVIRONMENTAL_CONTROLLER;
    public static final int GUI_MATTER_BEAMER;
    public static final int GUI_SPAWNER;
    public static final int GUI_BLOCK_PROTECTOR;
    public static final int GUI_ITEMFILTER;
    public static final int GUI_SECURITY_MANAGER;
    public static final int GUI_DEVELOPERS_DELIGHT;
    public static final int GUI_LIST_BLOCKS;
    public static final int GUI_ENDERGENIC;
    public static final int GUI_PEARL_INJECTOR;
    public static final int GUI_ENDERMONITOR;
    public static final int GUI_STORAGE_SCANNER;
    public static final int GUI_BOOSTER;
    public static final int GUI_INVCHECKER;
    public static final int GUI_SENSOR;
    public static final int GUI_STORAGE_TERMINAL;
    public static final int GUI_STORAGE_TERMINAL_SCANNER;
    public static final int GUI_ELEVATOR;

    public String getModId() {
        return MODID;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        proxy.preInit(e);
        MainCompatHandler.registerWaila();
        MainCompatHandler.registerTOP();
        WheelSupport.registerWheel();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init(e);
        Achievements.init();
        this.rftoolsDimensions = Loader.isModLoaded((String)"rftoolsdim");
        if (this.rftoolsDimensions) {
            Logging.log((String)"RFTools Detected Dimensions addon: enabling support");
            FMLInterModComms.sendFunctionMessage((String)"rftoolsdim", (String)"getDimensionManager", (String)"mcjty.rftools.apideps.RFToolsDimensionChecker$GetDimensionManager");
        }
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"mcjty.rftools.theoneprobe.TheOneProbeSupport");
        this.xnet = Loader.isModLoaded((String)"xnet");
        if (this.xnet) {
            Logging.log((String)"RFTools Detected XNet: enabling support");
            FMLInterModComms.sendFunctionMessage((String)"xnet", (String)"getXNet", (String)"mcjty.rftools.xnet.XNetSupport$GetXNet");
        }
        if (Loader.isModLoaded((String)"OpenComputers")) {
            OpenComputersIntegration.init();
        }
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandRftTp());
        event.registerServerCommand((ICommand)new CommandRftDb());
        event.registerServerCommand((ICommand)new CommandRftCfg());
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        Logging.log((String)"RFTools: server is stopping. Shutting down gracefully");
        TeleportDestinations.clearInstance();
        RemoteStorageIdRegistry.clearInstance();
        RedstoneChannels.clearInstance();
        PowerCellNetwork.clearInstance();
        SecurityChannels.clearInstance();
        BlockProtectors.clearInstance();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            Optional value;
            if (message.key.equalsIgnoreCase("getApi") || message.key.equalsIgnoreCase("getTeleportationManager")) {
                value = message.getFunctionValue(ITeleportationManager.class, Void.class);
                ((Function)value.get()).apply((Object)new TeleportationManager());
                continue;
            }
            if (!message.key.equalsIgnoreCase("getScreenModuleRegistry")) continue;
            value = message.getFunctionValue(IScreenModuleRegistry.class, Void.class);
            ((Function)value.get()).apply((Object)screenModuleRegistry);
        }
    }

    public void openManual(EntityPlayer player, int bookIndex, String page) {
        GuiRFToolsManual.locatePage = page;
        player.openGui((Object)instance, bookIndex, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }

    static {
        screenModuleRegistry = new ScreenModuleRegistry();
        modGuiIndex = 0;
        tabRfTools = new CompatCreativeTabs("RfTools"){

            @SideOnly(value=Side.CLIENT)
            public Item getItem() {
                return ModItems.rfToolsManualItem;
            }
        };
        GUI_MANUAL_MAIN = modGuiIndex++;
        GUI_COALGENERATOR = modGuiIndex++;
        GUI_CRAFTER = modGuiIndex++;
        GUI_MODULAR_STORAGE = modGuiIndex++;
        GUI_REMOTE_STORAGE = modGuiIndex++;
        GUI_STORAGE_FILTER = modGuiIndex++;
        GUI_REMOTE_STORAGE_ITEM = modGuiIndex++;
        GUI_MODULAR_STORAGE_ITEM = modGuiIndex++;
        GUI_REMOTE_STORAGESCANNER_ITEM = modGuiIndex++;
        GUI_DIALING_DEVICE = modGuiIndex++;
        GUI_MATTER_RECEIVER = modGuiIndex++;
        GUI_MATTER_TRANSMITTER = modGuiIndex++;
        GUI_ADVANCEDPORTER = modGuiIndex++;
        GUI_TELEPORTPROBE = modGuiIndex++;
        GUI_SCREEN = modGuiIndex++;
        GUI_SCREENCONTROLLER = modGuiIndex++;
        GUI_COUNTER = modGuiIndex++;
        GUI_SEQUENCER = modGuiIndex++;
        GUI_TIMER = modGuiIndex++;
        GUI_THREE_LOGIC = modGuiIndex++;
        GUI_MACHINE_INFUSER = modGuiIndex++;
        GUI_BUILDER = modGuiIndex++;
        GUI_SHAPECARD = modGuiIndex++;
        GUI_CHAMBER_DETAILS = modGuiIndex++;
        GUI_POWERCELL = modGuiIndex++;
        GUI_RELAY = modGuiIndex++;
        GUI_LIQUID_MONITOR = modGuiIndex++;
        GUI_RF_MONITOR = modGuiIndex++;
        GUI_SHIELD = modGuiIndex++;
        GUI_ENVIRONMENTAL_CONTROLLER = modGuiIndex++;
        GUI_MATTER_BEAMER = modGuiIndex++;
        GUI_SPAWNER = modGuiIndex++;
        GUI_BLOCK_PROTECTOR = modGuiIndex++;
        GUI_ITEMFILTER = modGuiIndex++;
        GUI_SECURITY_MANAGER = modGuiIndex++;
        GUI_DEVELOPERS_DELIGHT = modGuiIndex++;
        GUI_LIST_BLOCKS = modGuiIndex++;
        GUI_ENDERGENIC = modGuiIndex++;
        GUI_PEARL_INJECTOR = modGuiIndex++;
        GUI_ENDERMONITOR = modGuiIndex++;
        GUI_STORAGE_SCANNER = modGuiIndex++;
        GUI_BOOSTER = modGuiIndex++;
        GUI_INVCHECKER = modGuiIndex++;
        GUI_SENSOR = modGuiIndex++;
        GUI_STORAGE_TERMINAL = modGuiIndex++;
        GUI_STORAGE_TERMINAL_SCANNER = modGuiIndex++;
        GUI_ELEVATOR = modGuiIndex++;
    }
}

