/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility;

import com.infinityraider.infinitylib.InfinityLib;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WorldHelper {
    public static final <T> Optional<T> getBlock(IBlockAccess world, BlockPos pos, Class<T> type) {
        return Optional.ofNullable(world).map(w -> w.func_180495_p(pos)).map(s -> s.func_177230_c()).filter(b -> type.isAssignableFrom(b.getClass())).map(b -> type.cast(b));
    }

    public static final <T> Optional<T> getTile(IBlockAccess world, BlockPos pos, Class<T> type) {
        return Optional.ofNullable(world).map(w -> w.func_175625_s(pos)).filter(te -> type.isAssignableFrom(te.getClass())).map(te -> type.cast(te));
    }

    public static final <T> List<T> getTileNeighbors(World world, BlockPos pos, Class<T> type) {
        return WorldHelper.getTileNeighbors(world, pos, type, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST);
    }

    public static final <T> List<T> getTileNeighbors(World world, BlockPos pos, Class<T> type, EnumFacing ... dirs) {
        ArrayList<T> neighbours = new ArrayList<T>();
        for (EnumFacing dir : dirs) {
            TileEntity te = world.func_175625_s(pos.func_177982_a(dir.func_82601_c(), dir.func_96559_d(), dir.func_82599_e()));
            if (te == null || !type.isAssignableFrom(te.getClass())) continue;
            neighbours.add(type.cast(te));
        }
        return neighbours;
    }

    public static final void spawnItemInWorld(World world, BlockPos pos, Collection<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            WorldHelper.spawnItemInWorld(world, pos, stack);
        }
    }

    public static final void spawnItemInWorld(World world, BlockPos pos, ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            WorldHelper.spawnItemInWorld(world, pos, stack);
        }
    }

    public static final void spawnItemInWorld(World world, BlockPos pos, ItemStack stack) {
        if (world != null && pos != null && stack != null && stack.func_77973_b() != null) {
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
        } else {
            StringBuilder sb = new StringBuilder();
            Optional<World> optWorld = Optional.ofNullable(world);
            Optional<BlockPos> optPos = Optional.ofNullable(pos);
            Optional<ItemStack> optStack = Optional.ofNullable(stack);
            sb.append("\n");
            sb.append("==================================================\n");
            sb.append("InfinityLib Warning!\n");
            sb.append("==================================================\n");
            sb.append("\n");
            sb.append("Cause:\n");
            sb.append("--------------------------------------------------\n");
            sb.append("\tAn attempt at spawning a bad ItemStack in the world was intercepted!\n");
            sb.append("\n");
            sb.append("Relevant Data:\n");
            sb.append("--------------------------------------------------\n");
            sb.append("\t- In World: ").append(optWorld.map(w -> w.func_72912_H().func_76065_j()).orElse("<NULL>")).append("\n");
            sb.append("\t- At Location: ").append(optPos.map(p -> p.toString()).orElse("<NULL>")).append("\n");
            sb.append("\t- ItemStack:\n");
            sb.append("\t\t- Item: ").append(optStack.map(i -> i.func_77973_b()).map(i -> i.toString()).orElse("<NULL>")).append("\n");
            sb.append("\t\t- Amount: ").append(optStack.map(i -> i.field_77994_a).map(i -> i.toString()).orElse("<NULL>")).append("\n");
            sb.append("\t\t- Meta: ").append(optStack.filter(i -> i.func_77973_b() != null).map(i -> i.func_77960_j()).map(i -> i.toString()).orElse("<NULL>")).append("\n");
            sb.append("\t\t- Tags: ").append(optStack.map(i -> i.func_77978_p()).map(i -> i.toString()).orElse("<NULL>")).append("\n");
            sb.append("\n");
            sb.append("Stacktrace:\n");
            sb.append("--------------------------------------------------\n");
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                sb.append("\t").append(e.toString()).append("\n");
            }
            sb.append("==================================================\n");
            InfinityLib.instance.getLogger().error(sb.toString(), new Object[0]);
        }
    }
}

