/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility;

import com.infinityraider.infinitylib.InfinityMod;
import com.infinityraider.infinitylib.block.ICustomRenderedBlock;
import com.infinityraider.infinitylib.block.IInfinityBlock;
import com.infinityraider.infinitylib.block.IInfinityBlockWithTile;
import com.infinityraider.infinitylib.entity.EntityRegistryEntry;
import com.infinityraider.infinitylib.item.IAutoRenderedItem;
import com.infinityraider.infinitylib.item.ICustomRenderedItem;
import com.infinityraider.infinitylib.item.IInfinityItem;
import com.infinityraider.infinitylib.item.IItemWithModel;
import com.infinityraider.infinitylib.render.block.BlockRendererRegistry;
import com.infinityraider.infinitylib.render.item.ItemRendererRegistry;
import com.infinityraider.infinitylib.utility.IRecipeRegister;
import com.infinityraider.infinitylib.utility.ReflectionHelper;
import com.infinityraider.infinitylib.utility.RegisterHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.Tuple;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ModHelper {
    private static final ModHelper INSTANCE = new ModHelper();

    public static ModHelper getInstance() {
        return INSTANCE;
    }

    private ModHelper() {
    }

    public void RegisterBlocksAndItems(InfinityMod mod) {
        ReflectionHelper.forEachIn(mod.getModBlockRegistry(), IInfinityBlock.class, block -> {
            if (block instanceof Block && block.isEnabled()) {
                mod.getLogger().debug("Registering Block: " + block.getInternalName(), new Object[0]);
                RegisterHelper.registerBlock((Block)block, mod.getModId(), block.getInternalName(), block.getItemBlockClass());
                for (String tag : block.getOreTags()) {
                    OreDictionary.registerOre((String)tag, (Block)((Block)block));
                }
            }
        });
        ReflectionHelper.forEachIn(mod.getModItemRegistry(), IInfinityItem.class, item -> {
            if (item instanceof Item && item.isEnabled()) {
                mod.getLogger().debug("Registering Item: " + item.getInternalName(), new Object[0]);
                RegisterHelper.registerItem((Item)item, mod.getModId(), item.getInternalName());
                for (String tag : item.getOreTags()) {
                    OreDictionary.registerOre((String)tag, (Item)((Item)item));
                }
            }
        });
        ReflectionHelper.forEachIn(mod.getModBlockRegistry(), IInfinityBlockWithTile.class, block -> {
            if (block.isEnabled()) {
                mod.getLogger().debug("Registering Tile for Block: " + block.getInternalName(), new Object[0]);
                Object te = block.func_149915_a(null, 0);
                assert (te != null);
                GameRegistry.registerTileEntity(te.getClass(), (String)(mod.getModId().toLowerCase() + ":tile." + block.getInternalName()));
            }
        });
    }

    public void registerRecipes(InfinityMod mod) {
        ReflectionHelper.forEachIn(mod.getModBlockRegistry(), IRecipeRegister.class, IRecipeRegister::registerRecipes);
        ReflectionHelper.forEachIn(mod.getModItemRegistry(), IRecipeRegister.class, IRecipeRegister::registerRecipes);
    }

    @SideOnly(value=Side.CLIENT)
    public void initRenderers(InfinityMod mod) {
        ReflectionHelper.forEachIn(mod.getModBlockRegistry(), IInfinityBlock.class, block -> {
            if (block.isEnabled() && block instanceof ICustomRenderedBlock) {
                BlockRendererRegistry.getInstance().registerCustomBlockRenderer((ICustomRenderedBlock)block);
            }
        });
        for (ICustomRenderedBlock block2 : BlockRendererRegistry.getInstance().getRegisteredBlocks()) {
            mod.getLogger().debug("registered custom renderer for " + block2.getBlockModelResourceLocation(), new Object[0]);
        }
        ReflectionHelper.forEachIn(mod.getModItemRegistry(), IInfinityItem.class, item -> {
            if (item instanceof Item && item.isEnabled()) {
                if (item instanceof IItemWithModel) {
                    for (Tuple<Integer, ModelResourceLocation> entry : ((IItemWithModel)item).getModelDefinitions()) {
                        ModelLoader.setCustomModelResourceLocation((Item)((Item)item), (int)((Integer)entry.func_76341_a()), (ModelResourceLocation)((ModelResourceLocation)entry.func_76340_b()));
                    }
                }
                if (item instanceof IAutoRenderedItem) {
                    ItemRendererRegistry.getInstance().registerCustomItemRendererAuto((Item)((IAutoRenderedItem)((Item)item)));
                } else if (item instanceof ICustomRenderedItem) {
                    ItemRendererRegistry.getInstance().registerCustomItemRenderer((Item)item, ((ICustomRenderedItem)item).getRenderer());
                }
            }
        });
    }

    public void registerEntities(InfinityMod mod) {
        ReflectionHelper.forEachIn(mod.getModEntityRegistry(), EntityRegistryEntry.class, entry -> {
            if (entry.isEnabled()) {
                entry.register(mod);
                entry = null;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void registerEntitiesClient(InfinityMod mod) {
        ReflectionHelper.forEachIn(mod.getModEntityRegistry(), EntityRegistryEntry.class, entry -> {
            if (entry.isEnabled()) {
                entry.registerClient(mod);
            }
        });
    }
}

