/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.capability;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public final class CapabilityProvider<C>
implements ICapabilitySerializable<NBTTagCompound> {
    private final Capability<C> capability;
    private final C value;

    public CapabilityProvider(Capability<C> capability, C value) {
        this.capability = capability;
        this.value = value;
    }

    public Capability<C> getCapability() {
        return this.capability;
    }

    public C getCapabilityValue() {
        return this.value;
    }

    public NBTTagCompound serializeNBT() {
        return (NBTTagCompound)this.getCapability().getStorage().writeNBT(this.getCapability(), this.getCapabilityValue(), null);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.getCapability().getStorage().readNBT(this.getCapability(), this.getCapabilityValue(), null, (NBTBase)nbt);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability() != null && capability == this.getCapability();
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(this.hasCapability(capability, facing) ? this.getCapability().cast(this.value) : null);
    }
}

