/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.block.blockstate;

import com.infinityraider.infinitylib.utility.NBTHelper;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IUnlistedProperty;

public class SidedConnection {
    private boolean[] connections = new boolean[EnumFacing.values().length + 1];

    public boolean isConnected(EnumFacing side) {
        return this.connections[this.getIndex(side)];
    }

    public SidedConnection setConnected(EnumFacing side, boolean value) {
        this.connections[this.getIndex((EnumFacing)side)] = value;
        return this;
    }

    private int getIndex(EnumFacing side) {
        return side == null ? EnumFacing.values().length : side.ordinal();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SidedConnection) {
            return Arrays.equals(this.connections, ((SidedConnection)object).connections);
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.connections);
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTHelper.writeBoolArray("IL_CONNECTION", tag, this.connections);
    }

    public void readFromNBT(NBTTagCompound tag) {
        boolean[] connections = NBTHelper.readBoolArray("IL_CONNECTION", tag);
        if (connections.length == this.connections.length) {
            this.connections = connections;
        }
    }

    public static class Property
    implements IUnlistedProperty<SidedConnection> {
        private final String name;

        public Property(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isValid(SidedConnection value) {
            return true;
        }

        public Class<SidedConnection> getType() {
            return SidedConnection.class;
        }

        public String valueToString(SidedConnection value) {
            return value.toString();
        }
    }
}

