/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.client.renderer.font;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import li.cil.oc.OpenComputers;
import li.cil.oc.Settings;
import li.cil.oc.client.renderer.font.IGlyphProvider;
import li.cil.oc.util.FontUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;

public class FontParserHex
implements IGlyphProvider {
    private static final byte[] OPAQUE = new byte[]{-1, -1, -1, -1};
    private static final byte[] TRANSPARENT = new byte[]{0, 0, 0, 0};
    private final byte[][] glyphs = new byte[65536][];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        for (int i = 0; i < this.glyphs.length; ++i) {
            this.glyphs[i] = null;
        }
        try {
            InputStream font = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(Settings.resourceDomain(), "font.hex")).func_110527_b();
            OpenComputers.log().info("Initialized unicode glyph provider.");
            try {
                String line;
                OpenComputers.log().info("Initializing unicode glyph provider.");
                BufferedReader input = new BufferedReader(new InputStreamReader(font));
                int glyphCount = 0;
                while ((line = input.readLine()) != null) {
                    int expectedWidth;
                    String[] info = line.split(":");
                    int charCode = Integer.parseInt(info[0], 16);
                    if (charCode < 0 || charCode >= this.glyphs.length || (expectedWidth = FontUtils.wcwidth(charCode)) < 1) continue;
                    byte[] glyph = new byte[info[1].length() >> 1];
                    int glyphWidth = glyph.length / this.getGlyphHeight();
                    if (expectedWidth == glyphWidth) {
                        for (int i = 0; i < glyph.length; ++i) {
                            glyph[i] = (byte)Integer.parseInt(info[1].substring(i * 2, i * 2 + 2), 16);
                        }
                        if (this.glyphs[charCode] == null) {
                            ++glyphCount;
                        }
                        this.glyphs[charCode] = glyph;
                        continue;
                    }
                    if (!Settings.get().logHexFontErrors()) continue;
                    OpenComputers.log().warn(String.format("Size of glyph for code point U+%04X (%s) in font (%d) does not match expected width (%d), ignoring.", charCode, String.valueOf((char)charCode), glyphWidth, expectedWidth));
                }
                OpenComputers.log().info("Loaded " + glyphCount + " glyphs.");
            }
            finally {
                try {
                    font.close();
                }
                catch (IOException ex) {
                    OpenComputers.log().warn("Error parsing font.", (Throwable)ex);
                }
            }
        }
        catch (IOException ex) {
            OpenComputers.log().warn("Failed loading glyphs.", (Throwable)ex);
        }
    }

    @Override
    public ByteBuffer getGlyph(int charCode) {
        if (charCode < 0 || charCode >= this.glyphs.length || this.glyphs[charCode] == null || this.glyphs[charCode].length == 0) {
            return null;
        }
        byte[] glyph = this.glyphs[charCode];
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(glyph.length * this.getGlyphWidth() * 4));
        for (byte aGlyph : glyph) {
            int c = aGlyph & 0xFF;
            for (int j = 0; j < 8; ++j) {
                boolean isBitSet;
                boolean bl = isBitSet = (c & 0x80) > 0;
                if (isBitSet) {
                    buffer.put(OPAQUE);
                } else {
                    buffer.put(TRANSPARENT);
                }
                c <<= 1;
            }
        }
        buffer.rewind();
        return buffer;
    }

    @Override
    public int getGlyphWidth() {
        return 8;
    }

    @Override
    public int getGlyphHeight() {
        return 16;
    }
}

