/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.elements.tconstruct;

import io.github.drmanganese.topaddons.elements.ElementRenderHelper;
import io.github.drmanganese.topaddons.styles.ProgressStyleSmelteryFluid;
import io.github.drmanganese.topaddons.styles.ProgressStyleTank;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.apiimpl.client.ElementProgressRender;
import mcjty.theoneprobe.network.NetworkTools;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.FluidStack;

public class ElementSmelteryTank
implements IElement {
    private int id;
    private final List<SmelteryFluid> fluids;
    private final int capacity;
    private final boolean inIngots;
    private final boolean sneaking;
    private final int gaugeHeight;

    public ElementSmelteryTank(int id, List<FluidStack> fluids, int capacity, boolean inIngots, boolean sneaking) {
        this.id = id;
        this.fluids = new ArrayList<SmelteryFluid>();
        fluids.forEach(fluidStack -> this.fluids.add(new SmelteryFluid(fluidStack.getLocalizedName(), fluidStack.amount, fluidStack.getFluid().getColor(), capacity)));
        this.capacity = capacity;
        this.inIngots = inIngots;
        this.sneaking = sneaking;
        this.gaugeHeight = this.calcGaugeHeight();
    }

    public ElementSmelteryTank(ByteBuf buf) {
        this.fluids = new ArrayList<SmelteryFluid>();
        int count = buf.readInt();
        this.capacity = buf.readInt();
        for (int i = 0; i < count; ++i) {
            this.fluids.add(new SmelteryFluid(NetworkTools.readString((ByteBuf)buf), buf.readInt(), buf.readInt(), this.capacity));
        }
        this.inIngots = buf.readBoolean();
        this.sneaking = buf.readBoolean();
        this.gaugeHeight = this.calcGaugeHeight();
    }

    private int calcGaugeHeight() {
        int sum = 0;
        for (SmelteryFluid fluid : this.fluids) {
            sum += fluid.height;
        }
        return Math.max(sum, 100);
    }

    public void render(int x, int y) {
        if (!this.sneaking) {
            int i;
            ElementProgressRender.render((IProgressStyle)new ProgressStyleTank(), (long)0L, (long)this.capacity, (int)x, (int)y, (int)100, (int)12);
            int xOffset = 0;
            for (i = 0; i < this.fluids.size(); ++i) {
                SmelteryFluid fluid = this.fluids.get(i);
                if (i > 0) {
                    xOffset = (int)((double)xOffset + Math.ceil(100 * this.fluids.get((int)(i - 1)).amount / this.capacity));
                }
                ElementProgressRender.render((IProgressStyle)new ProgressStyleSmelteryFluid().backgroundColor(0xFFFFFF).filledColor(fluid.color).alternateFilledColor(fluid.darker).showText(false), (long)fluid.amount, (long)this.capacity, (int)(x + xOffset), (int)y, (int)100, (int)12);
            }
            for (i = 1; i < 10; ++i) {
                RenderHelper.drawVerticalLine((int)(x + i * 10), (int)(y + 1), (int)(y + (i == 5 ? 11 : 6)), (int)-9013642);
            }
            RenderHelper.drawVerticalLine((int)(x + 99), (int)y, (int)(y + 12), (int)-6908266);
        } else {
            int i;
            ElementRenderHelper.drawGreyBox(x, y, x + 100, y + this.gaugeHeight + 2);
            int yOffset = 0;
            for (i = 0; i < this.fluids.size(); ++i) {
                String unit;
                int unitAmount;
                SmelteryFluid fluid = this.fluids.get(i);
                if (i > 0) {
                    yOffset += this.fluids.get((int)(i - 1)).height;
                }
                this.drawVerticalProgress(x, y - yOffset, fluid.amount, this.capacity, fluid.color, fluid.darker, fluid.height);
                int n = unitAmount = fluid.name.equals("Molten Emerald") ? 666 : 144;
                if (this.inIngots && fluid.amount >= unitAmount) {
                    String type = fluid.name.equals("Molten Emerald") ? "gem" : "ingot";
                    int r = fluid.amount % unitAmount;
                    int amount = (fluid.amount - r) / unitAmount;
                    if (amount > 1) {
                        type = type + 's';
                    }
                    unit = amount + " " + type + " of " + fluid.name;
                    if (r > 0) {
                        unit = '>' + unit;
                    }
                } else {
                    unit = fluid.amount + "mB of " + fluid.name;
                }
                ElementRenderHelper.drawSmallText(x + 98 - Minecraft.func_71410_x().field_71466_p.func_78256_a(unit) / 2, y + this.gaugeHeight - 4 - yOffset, unit, fluid.brighter2);
            }
            for (i = 1; i < 10; ++i) {
                RenderHelper.drawHorizontalLine((int)(x + 1), (int)(y + 10 * i), (int)(x + (i == 5 ? 99 : (i % 2 == 0 ? 25 : 15))), (int)-1435077002);
            }
        }
        ElementRenderHelper.drawSmallText(x + 1, y + (this.sneaking ? this.gaugeHeight + 4 : 13), "Smeltery", -1);
    }

    public int getWidth() {
        return 100;
    }

    public int getHeight() {
        return this.sneaking ? this.gaugeHeight + 8 : 18;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.fluids.size());
        buf.writeInt(this.capacity);
        this.fluids.forEach(fluid -> {
            NetworkTools.writeString((ByteBuf)buf, (String)fluid.name);
            buf.writeInt(fluid.amount);
            buf.writeInt(fluid.color);
        });
        buf.writeBoolean(this.inIngots);
        buf.writeBoolean(this.sneaking);
    }

    private void drawVerticalProgress(int x, int y, int amount, int capacity, int color, int dcolor, int height) {
        for (int i = 0; i < height; ++i) {
            RenderHelper.drawHorizontalLine((int)(x + 1), (int)(y + this.gaugeHeight - i), (int)(x + 99), (int)((y + this.gaugeHeight - 2 - i) % 2 == 0 ? dcolor : color));
        }
    }

    public int getID() {
        return this.id;
    }

    private final class SmelteryFluid {
        final String name;
        final int amount;
        final int color;
        final int darker;
        final int brighter2;
        int height;
        boolean wasTooShort = false;

        SmelteryFluid(String name, int amount, int color, int capacity) {
            this.name = name;
            this.amount = amount;
            this.color = color;
            this.darker = new Color(color).darker().hashCode();
            this.brighter2 = new Color(color).brighter().brighter().hashCode();
            this.height = (int)Math.floor(amount * 100 / capacity);
            if (this.height < 5) {
                this.height = 5;
                this.wasTooShort = true;
            }
        }
    }
}

