/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.elements.bloodmagic;

import WayofTime.bloodmagic.api.orb.IBloodOrb;
import io.github.drmanganese.topaddons.elements.ElementRenderHelper;
import io.netty.buffer.ByteBuf;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.network.NetworkTools;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ElementAltarCrafting
implements IElement {
    private int id;
    private final ItemStack input;
    private final ItemStack result;
    private final int progress;
    private final int required;
    private final float consumption;

    public ElementAltarCrafting(int id, ItemStack input, ItemStack result, int progress, int required, float consumption) {
        this.id = id;
        this.input = input;
        this.result = result;
        this.progress = progress;
        this.required = required;
        this.consumption = consumption;
    }

    public ElementAltarCrafting(ByteBuf buf) {
        this.input = NetworkTools.readItemStack((ByteBuf)buf);
        this.result = NetworkTools.readItemStack((ByteBuf)buf);
        this.progress = buf.readInt();
        this.required = buf.readInt();
        this.consumption = buf.readFloat();
    }

    public void render(int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderHelper.renderItemStack((Minecraft)mc, (RenderItem)mc.func_175599_af(), (ItemStack)this.input, (int)x, (int)y, (String)"");
        RenderHelper.renderItemStack((Minecraft)mc, (RenderItem)mc.func_175599_af(), (ItemStack)this.result, (int)(x + 84), (int)y, (String)"");
        ElementRenderHelper.drawGreyBox(x + 18, y + 3, x + 82, y + 13);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        mc.func_110434_K().func_110577_a(new ResourceLocation("topaddons:textures/elements/bm_altar.png"));
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buf = tessellator.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b((double)(x + 19), (double)(y + 4), 0.0).func_187315_a((double)(1.0f - (float)this.progress / (float)this.required), 0.0).func_181675_d();
        buf.func_181662_b((double)(x + 19), (double)(y + 12), 0.0).func_187315_a((double)(1.0f - (float)this.progress / (float)this.required), 1.0).func_181675_d();
        buf.func_181662_b((double)(x + 19 + 62 * this.progress / this.required), (double)(y + 12), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b((double)(x + 19 + 62 * this.progress / this.required), (double)(y + 4), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        String text = this.progress + "/" + this.required + " LP";
        ElementRenderHelper.drawSmallText(x + 50 - mc.field_71466_p.func_78256_a(text) / 4, y + 6, text, -1);
        text = this.input.func_77973_b() instanceof IBloodOrb ? I18n.func_135052_a((String)"topaddons.bloodmagic:filling", (Object[])new Object[0]) : I18n.func_135052_a((String)"topaddons.ic2:consumption", (Object[])new Object[0]) + ": " + this.consumption + " LP";
        ElementRenderHelper.drawSmallText(x + 50 - mc.field_71466_p.func_78256_a(text) / 4, y + 14, text, -1);
    }

    public int getWidth() {
        return 100;
    }

    public int getHeight() {
        return 18;
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)this.input);
        NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)this.result);
        buf.writeInt(this.progress);
        buf.writeInt(this.required);
        buf.writeFloat(this.consumption);
    }

    public int getID() {
        return this.id;
    }
}

