/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import io.github.drmanganese.topaddons.TOPAddons;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.api.TOPAddon;
import io.github.drmanganese.topaddons.config.capabilities.IClientOptsCapability;
import java.util.Collections;
import java.util.List;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

@TOPAddon(dependency="Forge", fancyName="Vanilla")
public class AddonVanilla
extends AddonBlank {
    private static final String[] NOTES = new String[]{"F\u266f/G\u266d", "G", "G\u266f/A\u266d", "A", "A\u266f/B\u266d", "B", "C", "C\u266f/D\u266d", "D", "D\u266f/E\u266d", "E", "F"};
    private boolean breedingCooldown = true;
    private boolean growupTimer = true;

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tile = world.func_175625_s(data.getPos());
        if (tile instanceof TileEntityNote && ((IClientOptsCapability)player.getCapability(TOPAddons.OPTS_CAP, null)).getBoolean("showPitch")) {
            AddonVanilla.textPrefixed(probeInfo, "{*topaddons.vanilla:pitch*}", NOTES[((TileEntityNote)tile).field_145879_a % 12]);
            Material material = world.func_180495_p(data.getPos().func_177977_b()).func_185904_a();
            String instrument = material == Material.field_151576_e ? "{*topaddons.vanilla:rock*}" : (material == Material.field_151595_p ? "{*topaddons.vanilla:sand*}" : (material == Material.field_151592_s ? "{*topaddons.vanilla:glass*}" : (material == Material.field_151575_d ? "{*topaddons.vanilla:wood*}" : "{*topaddons.vanilla:else*}")));
            AddonVanilla.textPrefixed(probeInfo, "{*topaddons.vanilla:instrument*}", instrument);
        }
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (entity instanceof EntityAnimal && (mode == ProbeMode.EXTENDED || ((EntityAnimal)entity).func_70877_b(player.func_184586_b(EnumHand.MAIN_HAND)) || ((EntityAnimal)entity).func_70877_b(player.func_184586_b(EnumHand.OFF_HAND)))) {
            int age = ((EntityAnimal)entity).func_70874_b();
            int mins = age / 1200;
            int secs = age / 20 - mins * 60;
            if (age > 0 && this.breedingCooldown) {
                AddonVanilla.textPrefixed(probeInfo, "{*topaddons.vanilla:nobreed*}", String.format(mins == 0 ? "%d\"" : "%d'%d\"", mins == 0 ? secs : mins, secs), TextFormatting.RED);
            } else if (age < 0 && this.growupTimer) {
                AddonVanilla.textPrefixed(probeInfo, "{*topaddons.vanilla:adultin*}", String.format(mins == 0 ? "%d\"" : "%d'%d\"", mins == 0 ? -secs : -mins, -secs));
            }
        }
    }

    @Override
    public void updateConfigs(Configuration config) {
        this.breedingCooldown = config.get("vanilla", "showBreedingCooldown", true, "Show animal breeding cooldown.").setLanguageKey("topaddons.config:vanilla_breeding_cooldown").getBoolean();
        this.growupTimer = config.get("vanilla", "growupTimer", true, "Show animal grow up timer.").setLanguageKey("topaddons.config:vanilla_growup_timer").getBoolean();
    }

    @Override
    public List<IBlockDisplayOverride> getBlockDisplayOverrides() {
        return Collections.singletonList(new IBlockDisplayOverride(){

            public boolean overrideStandardInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
                if (blockState.func_177230_c() == Blocks.field_150384_bq) {
                    if (Tools.show((ProbeMode)mode, (IProbeConfig.ConfigMode)Config.getRealConfig().getShowModName())) {
                        probeInfo.horizontal().vertical().text(Blocks.field_150378_br.func_149732_F()).text(TextStyleClass.MODNAME + Tools.getModName((Block)Blocks.field_150384_bq));
                    } else {
                        probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(Blocks.field_150378_br.func_149732_F());
                    }
                    return true;
                }
                return false;
            }
        });
    }
}

