/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import com.google.common.collect.ImmutableSet;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IHiveTile;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.ITree;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.IErrorState;
import forestry.api.farming.FarmDirection;
import forestry.api.genetics.IChromosomeType;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IEntityButterfly;
import forestry.apiculture.items.ItemArmorApiarist;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.apiculture.multiblock.TileAlvearySieve;
import forestry.apiculture.multiblock.TileAlvearySwarmer;
import forestry.apiculture.tiles.TileApiary;
import forestry.apiculture.tiles.TileBeeHousingBase;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.arboriculture.tiles.TileSapling;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.core.PluginCore;
import forestry.core.blocks.BlockBogEarth;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.Fluids;
import forestry.core.items.ItemArmorNaturalist;
import forestry.core.tiles.TileAnalyzer;
import forestry.core.tiles.TileEngine;
import forestry.core.tiles.TileForestry;
import forestry.core.utils.GeneticsUtil;
import forestry.energy.tiles.TileEngineBiogas;
import forestry.factory.tiles.TileFermenter;
import forestry.factory.tiles.TileMoistener;
import forestry.factory.tiles.TileRaintank;
import forestry.factory.tiles.TileStill;
import forestry.farming.multiblock.MultiblockLogicFarm;
import forestry.farming.tiles.TileFarm;
import io.github.drmanganese.topaddons.TOPAddons;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.api.TOPAddon;
import io.github.drmanganese.topaddons.config.capabilities.IClientOptsCapability;
import io.github.drmanganese.topaddons.elements.forestry.ElementBeeHousingInventory;
import io.github.drmanganese.topaddons.elements.forestry.ElementForestryFarm;
import io.github.drmanganese.topaddons.reference.Colors;
import io.github.drmanganese.topaddons.reference.EnumChip;
import io.github.drmanganese.topaddons.reference.Names;
import io.github.drmanganese.topaddons.styles.ProgressStyleForestryMultiColored;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

@TOPAddon(dependency="forestry")
public class AddonForestry
extends AddonBlank {
    private final List<IErrorState> NORMAL_STATES = Arrays.asList(EnumErrorCode.NO_QUEEN, EnumErrorCode.IS_RAINING, EnumErrorCode.NOT_DAY, EnumErrorCode.FORCED_COOLDOWN, EnumErrorCode.NO_SPECIMEN, EnumErrorCode.NOT_DARK);

    private void addFarmElement(IProbeInfo probeInfo, ItemStack[] farmIcons, String oneDirection, EntityPlayer player) {
        this.addFarmElement(probeInfo, farmIcons, oneDirection, false, new ItemStack[0], player);
    }

    private void addFarmElement(IProbeInfo probeInfo, ItemStack[] farmIcons, String oneDirection, boolean showInventory, ItemStack[] inventoryStacks, EntityPlayer player) {
        probeInfo.element((IElement)new ElementForestryFarm(this.getElementId(player, "farm"), farmIcons, oneDirection, showInventory, inventoryStacks));
    }

    private IProbeInfo addBeeHouseInventory(IProbeInfo probeInfo, boolean isApiary, ItemStack[] inventoryStacks, EntityPlayer player) {
        return probeInfo.element((IElement)new ElementBeeHousingInventory(this.getElementId(player, "bee_inventory"), isApiary, inventoryStacks));
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tile;
        if (blockState.func_177230_c() == PluginCore.blocks.bogEarth) {
            AddonForestry.textPrefixed(probeInfo, "{*topaddons.forestry:maturity*}", TextStyleClass.WARNING + String.valueOf((Integer)blockState.func_177229_b((IProperty)BlockBogEarth.MATURITY) * 100 / 3) + "%");
        }
        if ((tile = world.func_175625_s(data.getPos())) instanceof TileForestry || tile instanceof TileAlveary || tile instanceof TileTreeContainer || tile instanceof TileFarm) {
            int i;
            TileAnalyzer analyzer;
            ImmutableSet errorStates = tile instanceof IErrorLogicSource ? ((IErrorLogicSource)tile).getErrorLogic().getErrorStates() : ImmutableSet.of();
            if (tile instanceof IBeeHousing && !(tile instanceof IHiveTile)) {
                IBeeHousing beeHousing = (IBeeHousing)tile;
                ItemStack queen = beeHousing.getBeeInventory().getQueen();
                if (queen != null) {
                    int progress = beeHousing.getBeekeepingLogic().getBeeProgressPercent();
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(queen).progress(progress, 100, (IProgressStyle)new ProgressStyleForestryMultiColored(progress).showText(false));
                    if (mode == ProbeMode.EXTENDED) {
                        AddonForestry.textPrefixed(probeInfo, "{*for.gui.species*}", BeeManager.beeRoot.getMember(queen).getGenome().getSpeciesRoot().getMember(queen).getDisplayName());
                    }
                }
                if (mode == ProbeMode.EXTENDED) {
                    ItemStack stack;
                    int i2;
                    ItemStack[] inventoryStacks = new ItemStack[tile instanceof TileApiary ? 12 : 9];
                    if (tile instanceof TileAlveary) {
                        for (i2 = 0; i2 < 9; ++i2) {
                            stack = ((MultiblockLogicAlveary)((TileAlveary)tile).getMultiblockLogic()).getController().getInternalInventory().func_70301_a(i2);
                            inventoryStacks[i2] = stack != null ? stack : new ItemStack(Blocks.field_180401_cv);
                        }
                    } else if (tile instanceof TileBeeHousingBase) {
                        for (i2 = 0; i2 < 9; ++i2) {
                            stack = ((TileBeeHousingBase)tile).getInternalInventory().func_70301_a(i2);
                            inventoryStacks[i2] = stack != null ? stack : new ItemStack(Blocks.field_180401_cv);
                        }
                        if (tile instanceof TileApiary) {
                            for (i2 = 9; i2 < 12; ++i2) {
                                stack = ((TileApiary)tile).getInternalInventory().func_70301_a(i2);
                                inventoryStacks[i2] = stack != null ? stack : new ItemStack(Blocks.field_180401_cv);
                            }
                        }
                    }
                    this.addBeeHouseInventory(probeInfo, tile instanceof TileApiary, this.reorderBeeInvStacks(inventoryStacks), player);
                }
            }
            if (tile instanceof TileAnalyzer && (analyzer = (TileAnalyzer)tile).getIndividualOnDisplay() != null) {
                IProbeInfo horizontal = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
                horizontal.item(analyzer.getIndividualOnDisplay());
                horizontal.progress(analyzer.getProgressScaled(100), 100, (IProgressStyle)new ProgressStyleForestryMultiColored(analyzer.getProgressScaled(100)));
            }
            if (tile instanceof TileLeaves) {
                TileLeaves leaves = (TileLeaves)tile;
                if (leaves.hasFruit()) {
                    String ripeness = leaves.getRipeness() >= 1.0f ? TextStyleClass.OK + "{*topaddons.forestry:ripe*}" : TextFormatting.RED + "{*topaddons.forestry:unripe*}";
                    AddonForestry.textPrefixed(probeInfo, "{*topaddons.forestry:fruit*}", leaves.getTree().getGenome().getFruitProvider().getDescription() + " - " + ripeness);
                }
                if (leaves.isPollinated() && GeneticsUtil.hasNaturalistEye((EntityPlayer)player)) {
                    probeInfo.text(TextStyleClass.LABEL + "{*topaddons.forestry:pollinated*}");
                }
            }
            if (tile instanceof TileSapling) {
                ITree tree = ((TileSapling)tile).getTree();
                if (mode == ProbeMode.EXTENDED) {
                    if (tree != null && tree.isAnalyzed()) {
                        AddonForestry.textPrefixed(probeInfo, "{*for.gui.saplings*}", tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.FERTILITY).getName());
                        AddonForestry.textPrefixed(probeInfo, "{*for.gui.maturity*}", tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.MATURATION).getName());
                        AddonForestry.textPrefixed(probeInfo, "{*for.gui.height*}", tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.HEIGHT).getName());
                        AddonForestry.textPrefixed(probeInfo, "{*for.gui.girth*}", tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.GIRTH).toString());
                        AddonForestry.textPrefixed(probeInfo, "{*for.gui.yield*}", tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.YIELD).getName());
                        AddonForestry.textPrefixed(probeInfo, "{*for.gui.sappiness*}", tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.SAPPINESS).getName());
                    } else {
                        probeInfo.text(TextStyleClass.OBSOLETE + "{*for.gui.unknown*}");
                    }
                }
            }
            if (tile instanceof TileFarm) {
                TileFarm farm = (TileFarm)tile;
                EnumFacing facing = player.func_174811_aO();
                ItemStack[] farmIcons = new ItemStack[5];
                ItemStack socket = ((MultiblockLogicFarm)farm.getMultiblockLogic()).getController().getSocket(0);
                farmIcons[4] = socket != null ? socket : new ItemStack(Blocks.field_180401_cv);
                for (int i3 = 0; i3 < 4; ++i3) {
                    farmIcons[i3] = ((MultiblockLogicFarm)farm.getMultiblockLogic()).getController().getFarmLogic(FarmDirection.getFarmDirection((EnumFacing)facing)).getIconItemStack();
                    facing = facing.func_176746_e();
                }
                if (mode == ProbeMode.NORMAL) {
                    this.addFarmElement(probeInfo, farmIcons, facing.func_176610_l(), player);
                }
                if (mode == ProbeMode.EXTENDED) {
                    ItemStack[] inventoryStacks = new ItemStack[20];
                    for (i = 0; i < 20; ++i) {
                        inventoryStacks[i] = farm.getInternalInventory().func_70301_a(i) == null ? new ItemStack(Blocks.field_180401_cv) : farm.getInternalInventory().func_70301_a(i);
                    }
                    this.addFarmElement(probeInfo, farmIcons, facing.func_176610_l(), true, inventoryStacks, player);
                }
            }
            if (tile instanceof TileMoistener) {
                TileMoistener moistener = (TileMoistener)tile;
                int light = world.func_175699_k(data.getPos().func_177984_a());
                int speed = light > 11 ? 0 : (light >= 9 ? 1 : (light >= 7 ? 2 : (light >= 5 ? 3 : 4)));
                AddonForestry.textPrefixed(probeInfo, "{*topaddons.forestry:moistener_speed*}", (speed == 0 ? TextStyleClass.WARNING.toString() : "") + speed);
                ItemStack[] wheats = new ItemStack[]{new ItemStack(Items.field_151015_O, 0), new ItemStack((Item)PluginCore.items.mouldyWheat, 0), new ItemStack((Item)PluginCore.items.decayingWheat, 0), new ItemStack((Item)PluginCore.items.mulch, 0)};
                TextFormatting[] arrowColors = new TextFormatting[]{TextFormatting.DARK_GRAY, TextFormatting.DARK_GRAY, TextFormatting.DARK_GRAY};
                for (i = 0; i < 10; ++i) {
                    ItemStack stack = moistener.getInternalInventory().func_70301_a(i);
                    if (stack == null) continue;
                    for (int j = 0; j < wheats.length; ++j) {
                        if (!stack.func_77969_a(wheats[j])) continue;
                        wheats[j].field_77994_a += stack.field_77994_a;
                        if (i != 9) continue;
                        arrowColors[j] = TextFormatting.WHITE;
                    }
                }
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(wheats[0]).text(arrowColors[0] + "\u25b6").item(wheats[1]).text(arrowColors[1] + "\u25b6").item(wheats[2]).text(arrowColors[2] + "\u25b6").item(wheats[3]);
                if (moistener.getInternalInventory().func_70301_a(11) != null) {
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(moistener.getInternalInventory().func_70301_a(11)).progress(15 - moistener.getProductionProgressScaled(15), 15, probeInfo.defaultProgressStyle().showText(false).width(60)).item(moistener.getInternalInventory().func_70301_a(10));
                }
            }
            if (tile instanceof TileEngine) {
                TileEngine engine = (TileEngine)tile;
                if (mode == ProbeMode.EXTENDED) {
                    AddonForestry.textPrefixed(probeInfo, "{*topaddons.forestry:engine_stored*}", engine.getEnergyManager().getEnergyStored() + " RF");
                    AddonForestry.textPrefixed(probeInfo, "{*topaddons.forestry:engine_heat*}", engine.getHeat() / 10 + " C" + (errorStates.contains((Object)EnumErrorCode.FORCED_COOLDOWN) ? TextStyleClass.ERROR + " ({*for.errors.forced_cooldown.desc*})" : ""));
                }
                probeInfo.text(TextStyleClass.LABEL + "{*topaddons:generating*} " + TextStyleClass.INFOIMP + engine.getCurrentOutput() + TextStyleClass.LABEL + " RF/t");
            }
            if (errorStates.size() > 0) {
                probeInfo.text(TextStyleClass.ERROR + "{*topaddons.forestry:errors_nowork*}");
                errorStates.forEach(state -> {
                    if (mode == ProbeMode.EXTENDED || this.NORMAL_STATES.contains(state) && !((IClientOptsCapability)player.getCapability(TOPAddons.OPTS_CAP, null)).getBoolean("forestryReasonCrouch")) {
                        probeInfo.text(TextStyleClass.ERROR + "\u21aa " + TextStyleClass.WARNING + "{*" + state.getUnlocalizedDescription() + "*}");
                    }
                });
            }
        }
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (entity instanceof IEntityButterfly) {
            IButterfly butterfly = ((IEntityButterfly)entity).getButterfly();
            if (!butterfly.isPureBred((IChromosomeType)EnumButterflyChromosome.SPECIES)) {
                AddonForestry.textPrefixed(probeInfo, "{*for.gui.hybrid*}", butterfly.getGenome().getInactiveAllele((IChromosomeType)EnumButterflyChromosome.SPECIES).getName());
            }
            if (mode == ProbeMode.EXTENDED) {
                if (butterfly.isAnalyzed()) {
                    AddonForestry.textPrefixed(probeInfo, "{*for.gui.size*}", butterfly.getGenome().getActiveAllele((IChromosomeType)EnumButterflyChromosome.SIZE).getName());
                    AddonForestry.textPrefixed(probeInfo, "{*for.gui.speed*}", butterfly.getGenome().getActiveAllele((IChromosomeType)EnumButterflyChromosome.SPEED).getName());
                    AddonForestry.textPrefixed(probeInfo, "{*for.gui.lifespan*}", butterfly.getGenome().getActiveAllele((IChromosomeType)EnumButterflyChromosome.LIFESPAN).getName());
                    AddonForestry.textPrefixed(probeInfo, "{*for.gui.fertility*}", butterfly.getGenome().getActiveAllele((IChromosomeType)EnumButterflyChromosome.FERTILITY).getName());
                } else {
                    probeInfo.text(TextStyleClass.OBSOLETE + "{*for.gui.unknown*}");
                }
            }
        }
    }

    @Override
    public Map<Class<? extends ItemArmor>, EnumChip> getSpecialHelmets() {
        HashMap<Class<? extends ItemArmor>, EnumChip> map = new HashMap<Class<? extends ItemArmor>, EnumChip>(2);
        map.put(ItemArmorApiarist.class, EnumChip.STANDARD);
        map.put(ItemArmorNaturalist.class, EnumChip.SPECTACLES);
        return map;
    }

    @Override
    public void registerElements() {
        this.registerElement("farm", ElementForestryFarm::new);
        this.registerElement("bee_inventory", ElementBeeHousingInventory::new);
    }

    @Override
    public void addFluidColors() {
        for (Fluids fluid : Fluids.values()) {
            Colors.fluidColorMap.put(fluid.getFluid(), fluid.getParticleColor().hashCode());
        }
    }

    @Override
    public void addTankNames() {
        Names.tankNamesMap.put(TileEngineBiogas.class, new String[]{"Fuel", "Heating", "Burner"});
        Names.tankNamesMap.put(TileStill.class, new String[]{"In", "Out"});
        Names.tankNamesMap.put(TileFermenter.class, new String[]{"Resource Tank", "Product Tank"});
        Names.tankNamesMap.put(TileRaintank.class, new String[]{"Reservoir"});
    }

    @Override
    public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tile = world.func_175625_s(data.getPos());
        if (tile instanceof IBeeHousing && !(tile instanceof TileAlvearySieve) && !(tile instanceof TileAlvearySwarmer) || tile instanceof TileMoistener || tile instanceof TileFarm) {
            config.showChestContents(IProbeConfig.ConfigMode.NOT);
            config.showChestContentsDetailed(IProbeConfig.ConfigMode.NOT);
        } else {
            config.showChestContents(IProbeConfig.ConfigMode.EXTENDED);
            config.showChestContentsDetailed(IProbeConfig.ConfigMode.EXTENDED);
        }
    }

    private ItemStack[] reorderBeeInvStacks(ItemStack[] old) {
        ItemStack[] ret = new ItemStack[old.length];
        ret[0] = old[0];
        ret[1] = old[1];
        ret[2] = old[7];
        ret[3] = old[6];
        ret[4] = old[8];
        ret[5] = old[2];
        ret[6] = old[5];
        ret[7] = old[3];
        ret[8] = old[4];
        if (old.length > 9) {
            ret[9] = old[9];
            ret[10] = old[10];
            ret[11] = old[11];
        }
        return ret;
    }
}

